/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import journeymap.client.io.RegionImageHandler;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;

public class IgnSkin {
    private static String SKINS = "http://skins.minecraft.net/MinecraftSkins/%s.png";
    private static String DEFAULT = "Herobrine";

    public static BufferedImage downloadSkin(String username) {
        BufferedImage img = null;
        Object conn = null;
        try {
            String skinPath = String.format(SKINS, StringUtils.func_76338_a((String)username));
            img = IgnSkin.downloadImage(new URL(skinPath));
            if (img == null) {
                skinPath = String.format(SKINS, DEFAULT);
                img = IgnSkin.downloadImage(new URL(skinPath));
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().warn("Error getting skin image for " + username + ": " + e.getMessage());
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage downloadImage(URL imageURL) {
        BufferedImage img = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)imageURL.openConnection(Minecraft.func_71410_x().func_110437_J());
            HttpURLConnection.setFollowRedirects(true);
            conn.setInstanceFollowRedirects(true);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            if (conn.getResponseCode() / 100 == 2) {
                Graphics2D g;
                BufferedImage fullImage = ImageIO.read(conn.getInputStream());
                BufferedImage face = fullImage.getSubimage(8, 8, 8, 8);
                if (fullImage.getColorModel().hasAlpha()) {
                    g = RegionImageHandler.initRenderingHints(face.createGraphics());
                    BufferedImage hat = fullImage.getSubimage(40, 8, 8, 8);
                    g.drawImage(hat, 0, 0, 8, 8, null);
                    g.dispose();
                }
                img = new BufferedImage(24, 24, face.getType());
                g = RegionImageHandler.initRenderingHints(img.createGraphics());
                g.drawImage(face, 0, 0, 24, 24, null);
                g.dispose();
            } else {
                Journeymap.getLogger().debug("Bad Response getting image: " + imageURL + " : " + conn.getResponseCode());
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error getting skin image: " + imageURL + " : " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return img;
    }
}

