/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus;

import java.io.File;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ConfigManagerVenus {
    public static boolean loaded;
    static Configuration config;
    public static int dimensionIDVenus;
    public static boolean disableAmbientLightning;

    public ConfigManagerVenus(File file) {
        if (!loaded) {
            if (file.exists()) {
                config = new Configuration(file);
                ConfigManagerVenus.syncConfig(true, true);
                file.delete();
                config = ConfigManagerMars.config;
            } else {
                config = ConfigManagerMars.config;
                ConfigManagerVenus.syncConfig(true, false);
            }
        }
    }

    public static void syncConfig(boolean load, boolean update) {
        try {
            if (!ConfigManagerVenus.config.isChild && update) {
                config.load();
            }
            Property prop = config.get("dimensions", "dimensionIDVenus", -31);
            prop.setComment("Dimension ID for Venus");
            prop.setLanguageKey("gc.configgui.dimensionIDVenus").setRequiresMcRestart(true);
            if (update) {
                Property propCopy = ConfigManagerMars.config.get("dimensions", prop.getName(), prop.getInt(), prop.getComment());
                propCopy.setLanguageKey(prop.getLanguageKey());
                propCopy.setRequiresMcRestart(prop.requiresMcRestart());
            }
            dimensionIDVenus = prop.getInt();
            prop = config.get("schematic", "disableAmbientLightning", false);
            prop.setComment("Disables background thunder and lightning.");
            prop.setLanguageKey("gc.configgui.disable_ambient_lightning");
            disableAmbientLightning = prop.getBoolean(false);
            if (load) {
                ConfigManagerMars.config.setCategoryPropertyOrder("worldgen", ConfigManagerMars.propOrder);
            }
            if (ConfigManagerMars.config.hasChanged()) {
                ConfigManagerMars.config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Galacticraft Asteroids (Planets) has a problem loading it's config", (Object[])new Object[0]);
        }
    }
}

