/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTier2Rocket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTier2Rocket
extends Item
implements IHoldableItem,
ISortableItem {
    public ItemTier2Rocket() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean padFound = false;
        TileEntity tile = null;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        float centerX = -1.0f;
        float centerY = -1.0f;
        float centerZ = -1.0f;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos pos1 = pos.func_177982_a(i, 0, j);
                IBlockState state = world.func_180495_p(pos1);
                Block id = state.func_177230_c();
                int meta = id.func_176201_c(state);
                if (id != GCBlocks.landingPadFull || meta != 0) continue;
                padFound = true;
                tile = world.func_175625_s(pos1);
                centerX = (float)(pos.func_177958_n() + i) + 0.5f;
                centerY = (float)pos.func_177956_o() + 0.4f;
                centerZ = (float)(pos.func_177952_p() + j) + 0.5f;
                break;
            }
            if (padFound) break;
        }
        if (padFound) {
            if (tile instanceof TileEntityLandingPad) {
                if (((TileEntityLandingPad)tile).getDockedEntity() != null) {
                    return EnumActionResult.PASS;
                }
            } else {
                return EnumActionResult.PASS;
            }
            Object rocket = stack.func_77952_i() < 10 ? new EntityTier2Rocket(world, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i()]) : new EntityCargoRocket(world, centerX, centerY, centerZ, IRocketType.EnumRocketType.values()[stack.func_77952_i() - 10]);
            rocket.func_70107_b(((EntityAutoRocket)rocket).field_70165_t, ((EntityAutoRocket)rocket).field_70163_u + rocket.getOnPadYOffset(), ((EntityAutoRocket)rocket).field_70161_v);
            world.func_72838_d((Entity)rocket);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("RocketFuel")) {
                ((EntityAutoRocket)rocket).fuelTank.fill(new FluidStack(GCFluids.fluidFuel, stack.func_77978_p().func_74762_e("RocketFuel")), true);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (((IRocketType)rocket).getType().getPreFueled()) {
                if (rocket instanceof EntityTieredRocket) {
                    ((EntityTieredRocket)rocket).fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
                } else {
                    ((EntityCargoRocket)((Object)rocket)).fuelTank.fill(new FluidStack(GCFluids.fluidFuel, rocket.getMaxFuel()), true);
                }
            }
        } else {
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GalacticraftCore.galacticraftItemsTab || tab == CreativeTabs.field_78027_g) {
            int i;
            for (i = 0; i < IRocketType.EnumRocketType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
            for (i = 11; i < 10 + IRocketType.EnumRocketType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IRocketType.EnumRocketType type = par1ItemStack.func_77952_i() < 10 ? IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()] : IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10];
        if (!type.getTooltip().isEmpty()) {
            tooltip.add(type.getTooltip());
        }
        if (type.getPreFueled()) {
            tooltip.add(EnumColor.RED + "\u00a7o" + GCCoreUtil.translate((String)"gui.creative_only.desc"));
        }
        if (par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("RocketFuel")) {
            Object rocket = par1ItemStack.func_77952_i() < 10 ? new EntityTier2Rocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i()]) : new EntityCargoRocket((World)FMLClientHandler.instance().getWorldClient(), 0.0, 0.0, 0.0, IRocketType.EnumRocketType.values()[par1ItemStack.func_77952_i() - 10]);
            tooltip.add(GCCoreUtil.translate((String)"gui.message.fuel.name") + ": " + par1ItemStack.func_77978_p().func_74762_e("RocketFuel") + " / " + ((EntityAutoRocket)rocket).fuelTank.getCapacity());
        }
        if (par1ItemStack.func_77952_i() >= 10) {
            tooltip.add(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.requires_controller.desc"));
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + (par1ItemStack.func_77952_i() < 10 ? ".t2Rocket" : ".cargo_rocket");
    }

    public boolean shouldHoldLeftHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldHoldRightHandUp(EntityPlayer player) {
        return true;
    }

    public boolean shouldCrouch(EntityPlayer player) {
        return true;
    }

    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.ROCKET;
    }
}

