/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachineMarsT2
extends BlockTileGC
implements IShiftDescription,
ISortableBlock {
    public static final int GAS_LIQUEFIER_META = 0;
    public static final int METHANE_SYNTHESIZER_META = 4;
    public static final int ELECTROLYZER_META = 8;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachineMarsT2(String assetName) {
        super(GCBlocks.machine);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = state.func_177230_c().func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        worldIn.func_180501_a(pos, this.func_176203_a((metadata & 0xC) + change), 3);
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        TileBaseUniversalElectrical.onUseWrenchBlock((IBlockState)state, (World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)FACING)));
        return true;
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        playerIn.openGui((Object)GalacticraftPlanets.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if ((metadata &= 0xC) == 0) {
            return new TileEntityGasLiquefier();
        }
        if (metadata == 4) {
            return new TileEntityMethaneSynthesizer();
        }
        if (metadata == 8) {
            return new TileEntityElectrolyzer();
        }
        return null;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 4));
        list.add((Object)new ItemStack((Block)this, 1, 8));
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state) & 0xC;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        return new ItemStack((Block)this, 1, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGasLiquefier) {
            TileEntityGasLiquefier tileEntity = (TileEntityGasLiquefier)te;
            if (tileEntity.processTicks > 0) {
                float x = (float)pos.func_177958_n() + 0.5f;
                float y = (float)pos.func_177956_o() + 0.8f + 0.05f * (float)rand.nextInt(3);
                float z = (float)pos.func_177952_p() + 0.5f;
                for (float i = -0.41f + 0.16f * rand.nextFloat(); i < 0.5f; i += 0.167f) {
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3((double)(x + i), (double)y, (double)(z - 0.41f)), new Vector3(0.0, -0.015, -0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3((double)(x + i), (double)y, (double)(z + 0.537f)), new Vector3(0.0, -0.015, 0.0015), new Object[0]);
                    }
                    if (rand.nextInt(3) == 0) {
                        GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3((double)(x - 0.41f), (double)y, (double)(z + i)), new Vector3(-0.0015, -0.015, 0.0), new Object[0]);
                    }
                    if (rand.nextInt(3) != 0) continue;
                    GalacticraftCore.proxy.spawnParticle("whiteSmokeTiny", new Vector3((double)(x + 0.537f), (double)y, (double)(z + i)), new Vector3(0.0015, -0.015, 0.0), new Object[0]);
                }
            }
        }
    }

    public String getShiftDescription(int meta) {
        switch (meta) {
            case 8: {
                return GCCoreUtil.translate((String)"tile.electrolyzer.description");
            }
            case 0: {
                return GCCoreUtil.translate((String)"tile.gas_liquefier.description");
            }
            case 4: {
                return GCCoreUtil.translate((String)"tile.methane_synthesizer.description");
            }
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineType type = EnumMachineType.values()[meta / 4];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineType)((Object)state.func_177229_b((IProperty)TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        GAS_LIQUEFIER(0, "gas_liquefier"),
        METHANE_SYNTHESIZER(4, "methane_synthesizer"),
        ELECTROLYZER(8, "electrolyzer");

        private final int meta;
        private final String name;

        private EnumMachineType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

