/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.DynamicTextureProper;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.MapGen;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

public class MapUtil {
    public static AtomicBoolean calculatingMap = new AtomicBoolean();
    public static AtomicBoolean resetClientFlag = new AtomicBoolean();
    private static MapGen currentMap = null;
    private static MapGen slowMap = null;
    private static Thread threadCurrentMap = null;
    private static Thread threadSlowMap = null;
    public static boolean doneOverworldTexture = false;
    private static LinkedList<MapGen> queuedMaps = new LinkedList();
    public static LinkedList<String> clientRequests = new LinkedList();
    public static ArrayList<BlockVec3> biomeColours = new ArrayList(40);
    private static Random rand = new Random();
    private static byte[] overworldImageBytesPart;
    private static byte[] overworldImageCompressed;
    private static final int SIZE_STD = 176;
    public static final int SIZE_STD2 = 352;
    public static final int OVERWORLD_LARGEMAP_WIDTH = 1536;
    private static final int OVERWORLD_LARGEMAP_HEIGHT = 960;
    private static final int OVERWORLD_MAP_SCALE = 4;
    private static final int OVERWORLD_TEXTURE_WIDTH = 192;
    private static final int OVERWORLD_TEXTURE_HEIGHT = 48;
    private static final int OVERWORLD_TEXTURE_SCALE = 7;
    private static final int LARGEMAP_MARKER = 30000001;
    private static final int OCEAN_HEIGHT = 63;
    private static final int DEEP_OCEAN = 56;

    public static void reset() {
        if (currentMap != null) {
            currentMap.abort();
        }
        currentMap = null;
        MapUtil.saveMapProgress();
        threadCurrentMap = null;
        threadSlowMap = null;
        queuedMaps.clear();
        calculatingMap.set(false);
        doneOverworldTexture = false;
        overworldImageCompressed = null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetClient() {
        resetClientFlag.set(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetClientBody() {
        ClientProxyCore.overworldTexturesValid = false;
        clientRequests.clear();
        overworldImageBytesPart = null;
        File baseFolder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/galacticraftMaps");
        if (baseFolder.exists() && baseFolder.isDirectory()) {
            for (File f : baseFolder.listFiles()) {
                if (!f.isFile()) continue;
                f.delete();
            }
        }
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[0]));
        ClientProxyCore.overworldTextureRequestSent = true;
        DrawGameScreen.reusableMap = new DynamicTexture(352, 352);
        biomeColours.clear();
        MapUtil.setupColours();
    }

    public static void getLocalMap(World world, int chunkXPos, int chunkZPos, BufferedImage image) {
        for (int x0 = -12; x0 <= 12; ++x0) {
            for (int z0 = -12; z0 <= 12; ++z0) {
                Chunk chunk = world.func_72964_e(chunkXPos + x0, chunkZPos + z0);
                BlockPos pos = null;
                if (chunk == null) continue;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int l4 = chunk.func_177433_f(new BlockPos(x, 0, z)) + 1;
                        IBlockState state = Blocks.field_150350_a.func_176223_P();
                        if (l4 > 1) {
                            while ((state = chunk.func_186032_a(x, --l4, z)).func_185909_g((IBlockAccess)world, pos) == MapColor.field_151660_b && l4 > 0) {
                            }
                        }
                        int col = pos != null ? state.func_185909_g((IBlockAccess)world, pos).field_76291_p : 0;
                        image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                    }
                }
            }
        }
    }

    public static void makeOverworldTexture() {
        if (doneOverworldTexture) {
            return;
        }
        World overworld = WorldUtil.getProviderForDimensionServer((int)ConfigManagerCore.idDimensionOverworld).field_76579_a;
        if (overworld == null) {
            return;
        }
        if (overworld.func_175624_G() == WorldType.field_77138_c || !(overworld.field_73011_w instanceof WorldProviderSurface)) {
            doneOverworldTexture = true;
            return;
        }
        File baseFolder = new File(overworld.func_73046_m().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            doneOverworldTexture = true;
            return;
        }
        if (MapUtil.getBiomeMapForCoords(overworld, 0, 0, 7, 192, 48, baseFolder)) {
            doneOverworldTexture = true;
        }
        MapUtil.getBiomeMapForCoords(overworld, 0, 0, 4, 1536, 960, baseFolder);
    }

    public static void sendOverworldToClient(EntityPlayerMP client) {
        if (doneOverworldTexture) {
            try {
                File baseFolder = new File(client.field_70170_p.func_73046_m().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
                if (!baseFolder.exists()) {
                    GCLog.severe("Base folder missing: " + baseFolder.getAbsolutePath());
                    return;
                }
                File file = new File(baseFolder, "Overworld192.bin");
                if (file.exists()) {
                    MapUtil.sendMapPacket(0, 0, client, FileUtils.readFileToByteArray((File)file));
                }
                if ((file = new File(baseFolder, "Overworld1536.bin")).exists()) {
                    MapUtil.sendMapPacket(30000001, 0, client, FileUtils.readFileToByteArray((File)file));
                }
            }
            catch (Exception ex) {
                System.err.println("Error sending overworld image to player.");
                ex.printStackTrace();
            }
        }
    }

    public static void sendOrCreateMap(World world, int cx, int cz, EntityPlayerMP client) {
        if (world.func_175624_G() == WorldType.field_77138_c || !(world.field_73011_w instanceof WorldProviderSurface)) {
            doneOverworldTexture = true;
            return;
        }
        try {
            File baseFolder = new File(client.field_70170_p.func_73046_m().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
            if (!baseFolder.exists()) {
                GCLog.severe("Base folder missing: " + baseFolder.getAbsolutePath());
                return;
            }
            File file = MapUtil.makeFileName(baseFolder, cx, cz);
            if (!file.exists()) {
                MapUtil.getBiomeMapForCoords(world, cx, cz, 1, 176, 176, baseFolder);
                return;
            }
            MapUtil.sendMapPacket(cx, cz, client, FileUtils.readFileToByteArray((File)file));
        }
        catch (Exception ex) {
            System.err.println("Error sending map image to player.");
            ex.printStackTrace();
        }
    }

    public static void sendMapPacket(int cx, int cz, EntityPlayerMP client, byte[] largeMap) throws IOException {
        byte[] compressed;
        if (cx == 30000001) {
            if (overworldImageCompressed == null) {
                overworldImageCompressed = MapUtil.zipCompress(largeMap);
            }
            compressed = overworldImageCompressed;
        } else {
            compressed = MapUtil.zipCompress(largeMap);
        }
        MapUtil.sendMapPacketCompressed(cx, cz, client, compressed);
    }

    public static void sendMapPacketToAll(int cx, int cz, byte[] largeMap) {
        byte[] compressed;
        if (cx == 30000001) {
            if (overworldImageCompressed == null) {
                overworldImageCompressed = MapUtil.zipCompress(largeMap);
            }
            compressed = overworldImageCompressed;
        } else {
            compressed = MapUtil.zipCompress(largeMap);
        }
        MapUtil.sendMapPacketAllCompressed(cx, cz, compressed);
    }

    private static void sendMapPacketCompressed(int cx, int cz, EntityPlayerMP client, byte[] map) throws IOException {
        if (cx == 30000001 && map.length < 2040000) {
            int halfSize = map.length / 2;
            byte[] largeMapPartA = Arrays.copyOf(map, halfSize);
            byte[] largeMapPartB = Arrays.copyOfRange(map, halfSize, map.length);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID(client.field_70170_p), new Object[]{cx, map.length, largeMapPartA}), client);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID(client.field_70170_p), new Object[]{cx + 1, map.length, largeMapPartB}), client);
        } else if (map.length < 1020000) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID(client.field_70170_p), new Object[]{cx, cz, map}), client);
        }
    }

    private static void sendMapPacketAllCompressed(int cx, int cz, byte[] map) {
        if (cx == 30000001 && map.length < 2040000) {
            int halfSize = map.length / 2;
            byte[] largeMapPartA = Arrays.copyOf(map, halfSize);
            byte[] largeMapPartB = Arrays.copyOfRange(map, halfSize, map.length);
            GCCoreUtil.sendToAllDimensions(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{cx, map.length, largeMapPartA});
            GCCoreUtil.sendToAllDimensions(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{cx + 1, map.length, largeMapPartB});
        } else if (map.length < 1020000) {
            GCCoreUtil.sendToAllDimensions(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{cx, cz, map});
        }
    }

    public static boolean buildMaps(World world, int x, int z) {
        if (world.func_175624_G() == WorldType.field_77138_c || !(world.field_73011_w instanceof WorldProviderSurface)) {
            return false;
        }
        File baseFolder = new File(world.func_73046_m().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            return false;
        }
        int cx = MapUtil.convertMap(x);
        int cz = MapUtil.convertMap(z);
        MapUtil.getBiomeMapForCoords(world, cx, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx, cz - 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz + 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx - 352, cz - 352, 1, 176, 176, baseFolder);
        MapUtil.getBiomeMapForCoords(world, cx + 352, cz - 352, 1, 176, 176, baseFolder);
        return true;
    }

    private static int convertMap(int x) {
        int cx = x + 176;
        if (cx < 0) {
            cx -= 351;
        }
        return (cx /= 352) * 352;
    }

    public static boolean getBiomeMapForCoords(World world, int cx, int cz, int scale, int sizeX, int sizeZ, File baseFolder) {
        File outputFile;
        if (sizeX != sizeZ) {
            outputFile = new File(baseFolder, "Overworld" + sizeX + ".bin");
            if (sizeX == 1536) {
                MapGen newGen = new MapGen(world, sizeX, sizeZ, cx, cz, 1 << scale, outputFile);
                if (newGen.mapNeedsCalculating) {
                    slowMap = newGen;
                    calculatingMap.set(true);
                }
                return false;
            }
        } else {
            outputFile = MapUtil.makeFileName(baseFolder, cx, cz);
        }
        MapGen newGen = new MapGen(world, sizeX, sizeZ, cx, cz, 1 << scale, outputFile);
        if (newGen.mapNeedsCalculating) {
            if (calculatingMap.getAndSet(true)) {
                queuedMaps.add(newGen);
            } else {
                currentMap = newGen;
            }
            return false;
        }
        return true;
    }

    public static void saveMapProgress() {
        if (slowMap != null) {
            slowMap.abort();
            try {
                Thread.currentThread();
                Thread.sleep(90L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            slowMap.writeOutputFile(false);
            slowMap = null;
        }
    }

    public static void BiomeMapNextTick_MultiThreaded() {
        if (currentMap != null) {
            if (threadCurrentMap == null) {
                if (slowMap != null) {
                    slowMap.pause();
                }
                threadCurrentMap = new Thread(currentMap);
                threadCurrentMap.setName("Background world mapping");
                threadCurrentMap.setPriority(4);
                threadCurrentMap.start();
            } else if (MapUtil.currentMap.finishedCalculating.get()) {
                threadCurrentMap = null;
                currentMap.writeOutputFile(true);
                if (queuedMaps.size() > 0) {
                    currentMap = queuedMaps.removeFirst();
                } else {
                    currentMap = null;
                    if (slowMap == null) {
                        calculatingMap.set(false);
                    } else if (slowMap != null) {
                        slowMap.resume();
                    }
                }
            }
            return;
        }
        if (!queuedMaps.isEmpty()) {
            if (slowMap != null) {
                slowMap.pause();
            }
            currentMap = queuedMaps.removeFirst();
            return;
        }
        if (slowMap != null) {
            if (threadSlowMap == null) {
                threadSlowMap = new Thread(slowMap);
                threadSlowMap.setName("Background world mapping");
                threadSlowMap.setPriority(4);
                threadSlowMap.start();
            } else if (MapUtil.slowMap.finishedCalculating.get()) {
                threadSlowMap = null;
                slowMap.writeOutputFile(true);
                slowMap = null;
                calculatingMap.set(false);
            }
            return;
        }
    }

    public static void BiomeMapNextTick_SingleThreaded() {
        MapGen map;
        boolean doingSlow = false;
        if (currentMap != null) {
            map = currentMap;
        } else if (slowMap != null) {
            map = slowMap;
            doingSlow = true;
        } else {
            return;
        }
        long end = System.nanoTime() + 4500000L;
        while (System.nanoTime() < end) {
            if (!map.BiomeMapOneTick()) continue;
            map.writeOutputFile(true);
            if (doingSlow) {
                slowMap = null;
            } else {
                currentMap = null;
                if (queuedMaps.size() > 0) {
                    currentMap = queuedMaps.removeFirst();
                }
            }
            if (currentMap == null && slowMap == null) {
                calculatingMap.set(false);
            }
            return;
        }
    }

    public static boolean backgroundMapping(Thread currentThread) {
        return currentThread == threadSlowMap || currentThread == threadCurrentMap;
    }

    public static BufferedImage convertTo12pxTexture(BufferedImage overworldImage, BufferedImage paletteImage) {
        BufferedImage result = new BufferedImage(overworldImage.getWidth(), overworldImage.getHeight(), 1);
        TreeMap<Integer, Integer> mapColPos = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> mapColPosB = new TreeMap<Integer, Integer>();
        int count = 0;
        for (int x = 0; x < overworldImage.getWidth(); x += 4) {
            for (int z = 0; z < overworldImage.getHeight(); z += 4) {
                int r = 0;
                int g = 0;
                int b = 0;
                for (int xx = 0; xx < 4; ++xx) {
                    for (int zz = 0; zz < 4; ++zz) {
                        int col = overworldImage.getRGB(xx + x, zz + z);
                        r += col >> 16;
                        g += col >> 8 & 0xFF;
                        b += col & 0xFF;
                    }
                }
                while (mapColPos.containsKey(g - b)) {
                    ++g;
                }
                mapColPos.put(g - b, count);
                if (x < overworldImage.getHeight()) {
                    int col = paletteImage.getRGB(x + 1, z + 1);
                    r = col >> 16;
                    g = col >> 8 & 0xFF;
                    b = col & 0xFF;
                    while (mapColPosB.containsKey(g - b)) {
                        ++g;
                    }
                    mapColPosB.put(g - b, col);
                }
                ++count;
            }
        }
        count = 0;
        int newCol = 0;
        Iterator it = mapColPosB.keySet().iterator();
        Iterator itt = mapColPos.keySet().iterator();
        int modulus = overworldImage.getHeight() / 4;
        int mod2 = overworldImage.getWidth() / overworldImage.getHeight();
        for (int x = 0; x < overworldImage.getWidth() / 4; ++x) {
            for (int z = 0; z < modulus; ++z) {
                if (count % mod2 == 0) {
                    newCol = (Integer)mapColPosB.get(it.next());
                }
                int position = (Integer)mapColPos.get(itt.next());
                int xx = position / modulus;
                int zz = position % modulus;
                for (int xxx = 0; xxx < 4; ++xxx) {
                    for (int zzz = 0; zzz < 4; ++zzz) {
                        result.setRGB(xx * 4 + xxx, zz * 4 + zzz, newCol);
                    }
                }
                ++count;
            }
        }
        return result;
    }

    public static BufferedImage readImage(Object source) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(source);
        ImageReader reader = ImageIO.getImageReaders(stream).next();
        reader.setInput(stream);
        ImageReadParam param = reader.getDefaultReadParam();
        ImageTypeSpecifier typeToUse = null;
        Iterator<ImageTypeSpecifier> i = reader.getImageTypes(0);
        while (i.hasNext()) {
            ImageTypeSpecifier type = i.next();
            if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
            typeToUse = type;
        }
        if (typeToUse != null) {
            param.setDestinationType(typeToUse);
        }
        BufferedImage b = reader.read(0, param);
        reader.dispose();
        stream.close();
        return b;
    }

    @SideOnly(value=Side.CLIENT)
    public static void writeImgToFile(BufferedImage img, String name) {
        if (GalacticraftCore.enableJPEG) {
            File folder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/galacticraftMaps");
            try {
                FileImageOutputStream outputStreamA = new FileImageOutputStream(new File(folder, name));
                GalacticraftCore.jpgWriter.setOutput(outputStreamA);
                GalacticraftCore.jpgWriter.write(null, new IIOImage(img, null, null), GalacticraftCore.writeParam);
                outputStreamA.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] zipCompress(byte[] data) {
        Deflater deflater = new Deflater();
        deflater.setLevel(1);
        deflater.setInput(data);
        deflater.finish();
        ByteArrayOutputStream compressed = new ByteArrayOutputStream(data.length * 2 / 3);
        byte[] miniBuffer = new byte[4096];
        while (!deflater.finished()) {
            int count = deflater.deflate(miniBuffer);
            compressed.write(miniBuffer, 0, count);
        }
        return compressed.toByteArray();
    }

    private static byte[] zipDeCompress(byte[] data) throws DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream deCompressed = new ByteArrayOutputStream(data.length * 2);
        byte[] miniBuffer = new byte[4096];
        while (!inflater.finished()) {
            int count = inflater.inflate(miniBuffer);
            deCompressed.write(miniBuffer, 0, count);
        }
        return deCompressed.toByteArray();
    }

    @SideOnly(value=Side.CLIENT)
    public static void receiveOverworldImageCompressed(int cx, int cz, byte[] raw) throws IOException {
        byte[] overWorldImageComplete;
        if (cx == 30000001) {
            int offsetPartB;
            if (overworldImageBytesPart == null) {
                overworldImageBytesPart = raw;
                return;
            }
            overWorldImageComplete = Arrays.copyOf(raw, cz);
            for (int i = offsetPartB = cz / 2; i < cz; ++i) {
                overWorldImageComplete[i] = overworldImageBytesPart[i - offsetPartB];
            }
            overworldImageBytesPart = null;
            raw = overWorldImageComplete;
        } else if (cx == 30000002) {
            int offsetPartB;
            if (overworldImageBytesPart == null) {
                overworldImageBytesPart = raw;
                return;
            }
            overWorldImageComplete = Arrays.copyOf(overworldImageBytesPart, cz);
            for (int i = offsetPartB = cz / 2; i < cz; ++i) {
                overWorldImageComplete[i] = raw[i - offsetPartB];
            }
            overworldImageBytesPart = null;
            raw = overWorldImageComplete;
        }
        try {
            MapUtil.getOverworldImageFromRaw(cx, cz, MapUtil.zipDeCompress(raw));
        }
        catch (DataFormatException e) {
            GCLog.debug(e.toString());
            GCLog.debug("Client received a corrupted map image data packet from server " + cx + "_" + cz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void getOverworldImageFromRaw(int cx, int cz, byte[] raw) throws IOException {
        File folder = MapUtil.getClientMapsFolder();
        if (raw.length == 0x2D0000) {
            if (folder != null) {
                File file0 = new File(folder, "overworldRaw.bin");
                if (!file0.exists() || file0.canRead() && file0.canWrite()) {
                    FileUtils.writeByteArrayToFile((File)file0, (byte[])raw);
                } else {
                    System.err.println("Cannot write to file %minecraft%/assets/galacticraftMaps/overworldRaw.bin");
                }
            } else {
                System.err.println("No folder for file %minecraft%/assets/galacticraftMaps/overworldRaw.bin");
            }
            BufferedImage worldImageLarge = new BufferedImage(3072, 1920, 1);
            ArrayList cols = new ArrayList();
            int lastcol = -1;
            boolean idx = false;
            for (int x = 0; x < 1536; ++x) {
                for (int z = 0; z < 960; ++z) {
                    int arrayIndex = (x * 960 + z) * 2;
                    int biome = raw[arrayIndex] & 0xFF;
                    int height = raw[arrayIndex + 1] & 0xFF;
                    if (height < 63 && biome != 2 && biome != 10) {
                        biome = 0;
                    }
                    if (height < 56 && biome == 0) {
                        biome = 24;
                    }
                    worldImageLarge.setRGB(x * 2, z * 2, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2, z * 2 + 1, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2 + 1, z * 2, MapUtil.convertBiomeColour(biome, height));
                    worldImageLarge.setRGB(x * 2 + 1, z * 2 + 1, MapUtil.convertBiomeColour(biome, height));
                }
            }
            if (GalacticraftCore.enableJPEG && folder != null) {
                FileImageOutputStream outputStream = new FileImageOutputStream(new File(folder, "large.jpg"));
                GalacticraftCore.jpgWriter.setOutput(outputStream);
                GalacticraftCore.jpgWriter.write(null, new IIOImage(worldImageLarge, null, null), GalacticraftCore.writeParam);
                outputStream.close();
            }
        } else if (raw.length == 18432) {
            BufferedImage worldImage = new BufferedImage(192, 48, 1);
            ArrayList cols = new ArrayList();
            int lastcol = -1;
            boolean idx = false;
            for (int x = 0; x < 192; ++x) {
                for (int z = 0; z < 48; ++z) {
                    int arrayIndex = (x * 48 + z) * 2;
                    int biome = raw[arrayIndex] & 0xFF;
                    int height = raw[arrayIndex + 1] & 0xFF;
                    if (height < 63 && biome != 2 && biome != 10) {
                        biome = 0;
                    }
                    if (height < 56 && biome == 0) {
                        biome = 24;
                    }
                    worldImage.setRGB(x, z, MapUtil.convertBiomeColour(biome, height));
                }
            }
            IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
            BufferedImage paletteImage = null;
            try {
                InputStream in = rm.func_110536_a(new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png")).func_110527_b();
                paletteImage = ImageIO.read(in);
                in.close();
                paletteImage.getHeight();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            BufferedImage result = MapUtil.convertTo12pxTexture(worldImage, paletteImage);
            if (result != null) {
                if (ClientProxyCore.overworldTextureWide == null) {
                    ClientProxyCore.overworldTextureWide = new DynamicTextureProper(192, 48);
                }
                if (ClientProxyCore.overworldTextureClient == null) {
                    ClientProxyCore.overworldTextureClient = new DynamicTextureProper(48, 48);
                }
                ClientProxyCore.overworldTextureWide.update(result);
                ClientProxyCore.overworldTextureClient.update(result);
                ClientProxyCore.overworldTexturesValid = true;
            }
        } else if (folder != null) {
            File file0 = MapUtil.makeFileName(folder, cx, cz);
            if (!file0.exists() || file0.canRead() && file0.canWrite()) {
                FileUtils.writeByteArrayToFile((File)file0, (byte[])raw);
            }
        } else {
            System.err.println("No folder %minecraft%/assets/galacticraftMaps for local map file.");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getMap(int[] image, World world, BlockPos pos) {
        boolean result;
        int xCoord = pos.func_177958_n();
        int zCoord = pos.func_177952_p();
        int cx = MapUtil.convertMap(xCoord);
        int cz = MapUtil.convertMap(zCoord);
        File baseFolder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/galacticraftMaps");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            return false;
        }
        int dim = GCCoreUtil.getDimensionID(world);
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz - 352, 0, 0, xCoord, zCoord, dim, result = true)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz, 0, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx - 352, cz + 352, 0, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz - 352, 176, 0, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz, 176, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx, cz + 352, 176, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz - 352, 352, 0, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz, 352, 176, xCoord, zCoord, dim, result)) {
            result = false;
        }
        if (MapUtil.makeRGBimage(image, baseFolder, cx + 352, cz + 352, 352, 352, xCoord, zCoord, dim, result)) {
            result = false;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean makeRGBimage(int[] array, File baseFolder, int cx, int cz, int offsetX, int offsetZ, int xCoord, int zCoord, int dim, boolean prevResult) {
        int imagex;
        File filename = MapUtil.makeFileName(baseFolder, cx, cz);
        if (!filename.exists()) {
            if (!clientRequests.contains(filename.getName())) {
                clientRequests.add(filename.getName());
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_MAP_IMAGE, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[]{dim, cx, cz}));
            }
            return true;
        }
        if (!prevResult) {
            return true;
        }
        int ox = (MapUtil.convertMap(xCoord) - xCoord - 176) / 2;
        int oz = (MapUtil.convertMap(zCoord) - zCoord - 176) / 2;
        byte[] raw = null;
        try {
            raw = FileUtils.readFileToByteArray((File)filename);
        }
        catch (IOException e) {
            GCLog.severe("Problem reading map file: " + baseFolder.getAbsolutePath() + filename.getName());
            return true;
        }
        if (raw == null || raw.length != 61952) {
            GCLog.debug("Warning: unexpected map size is " + raw.length + " for file " + filename.toString());
            return true;
        }
        int xstart = Math.max(0, -offsetX - ox);
        int zstart = Math.max(0, -offsetZ - oz);
        for (int x = xstart; x < 176 && (imagex = x + offsetX + ox) < 352; ++x) {
            int imageZ;
            for (int z = zstart; z < 176 && (imageZ = z + oz + offsetZ) < 352; ++z) {
                int arrayIndex = (x * 176 + z) * 2;
                int biome = raw[arrayIndex] & 0xFF;
                int height = raw[arrayIndex + 1] & 0xFF;
                if (height < 63 && biome != 2 && biome != 10) {
                    biome = 0;
                }
                if (height < 56 && biome == 0) {
                    biome = 24;
                }
                if (imagex < 0 || imageZ < 0) {
                    GCLog.debug("Outside image " + imagex + "," + imageZ + " - " + "x=" + x + " z=" + z + " offsetX=" + offsetX + " offsetZ = " + offsetZ + " ox=" + ox + " oz=" + oz);
                    continue;
                }
                array[imagex + 352 * imageZ] = MapUtil.convertBiomeColour(biome, height) + -16777216;
            }
        }
        return false;
    }

    private static File makeFileName(File folder, int cx, int cz) {
        return new File(folder, "overworld" + cx / 352 + "_" + cz / 352 + ".bin");
    }

    private static int getBiomeBaseColour(int biomeId) {
        Biome biomegenbase = (Biome)Biome.field_185377_q.func_148754_a(biomeId);
        return 0;
    }

    public static int convertBiomeColour(int in, int height) {
        BlockVec3 bv;
        int rv;
        int s = biomeColours.size();
        if (in >= 128 && in < 128 + s) {
            in -= 128;
        }
        if ((rv = in >= s ? MapUtil.getBiomeBaseColour(in) : ((bv = biomeColours.get(in)) == null ? MapUtil.getBiomeBaseColour(in) : (bv.z > 0 && rand.nextInt(100) < bv.z ? bv.y : bv.x))) == 10232868 && rand.nextInt(2) == 0) {
            rv = 12559236;
        }
        if (height < 63) {
            return rv;
        }
        if (height > 92 && (in == 3 || in == 20 || in == 31 || in == 33 || in == 34) && rand.nextInt(8) > 98 - height) {
            rv = Material.field_151597_y.func_151565_r().field_76291_p;
        }
        float factor = ((float)height - 68.0f) / 94.0f;
        return ColorUtil.lighten(rv, factor);
    }

    private static void setupColours() {
        biomeColours.add(new BlockVec3(Material.field_151586_h.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(13946264, Material.field_151570_A.func_151565_r().field_76291_p, 3));
        biomeColours.add(new BlockVec3(5072204, Material.field_151576_e.func_151565_r().field_76291_p, 15));
        biomeColours.add(new BlockVec3(3962145, 2708502, 45));
        biomeColours.add(new BlockVec3(6454881, 1518103, 18));
        biomeColours.add(new BlockVec3(4412443, 1118985, 25));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 4813878, 3));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, Material.field_151588_w.func_151565_r().field_76291_p, 5));
        biomeColours.add(new BlockVec3(6510175, 8131604, 10));
        biomeColours.add(new BlockVec3(0x6A6066, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(13946264, 0, 0));
        biomeColours.add(new BlockVec3(3962145, 2708502, 35));
        biomeColours.add(new BlockVec3(6454881, 1518103, 14));
        biomeColours.add(new BlockVec3(5072204, 4813878, 50));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(3092436, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151576_e.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, Material.field_151597_y.func_151565_r().field_76291_p, 75));
        biomeColours.add(new BlockVec3(5335862, 4813878, 65));
        biomeColours.add(new BlockVec3(5335862, 4813878, 55));
        biomeColours.add(new BlockVec3(10232868, 1977880, 98));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(8092024, 4813878, 10));
        biomeColours.add(new BlockVec3(5657897, 2499332, 20));
        biomeColours.add(new BlockVec3(5657897, 2499332, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 17));
        biomeColours.add(new BlockVec3(10506783, 7417635, 20));
    }

    public static void makeVanillaMap(int dim, int chunkXPos, int chunkZPos, File baseFolder, BufferedImage image) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        for (int x0 = -12; x0 <= 12; ++x0) {
            for (int z0 = -12; z0 <= 12; ++z0) {
                Chunk chunk = world.func_72964_e(chunkXPos + x0, chunkZPos + z0);
                if (chunk == null) continue;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int l4 = chunk.func_76611_b(x, z) + 1;
                        IBlockState state = Blocks.field_150350_a.func_176223_P();
                        BlockPos pos = null;
                        if (l4 > 1) {
                            while ((state = chunk.func_177435_g(pos = new BlockPos(x, --l4, z))).func_185909_g((IBlockAccess)world, pos) == MapColor.field_151660_b && l4 > 0) {
                            }
                        }
                        int col = pos != null ? state.func_185909_g((IBlockAccess)world, pos).field_76291_p : 0;
                        image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                    }
                }
            }
        }
        try {
            File outputFile = new File(baseFolder, dim + "_" + chunkXPos + "_" + chunkZPos + ".jpg");
            if (!outputFile.exists() || outputFile.canWrite() && outputFile.canRead()) {
                ImageIO.write((RenderedImage)image, "jpg", outputFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static File getClientMapsFolder() {
        File folder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/galacticraftMaps");
        try {
            if (folder.exists() || folder.mkdirs()) {
                return folder;
            }
            System.err.println("Cannot create directory %minecraft%/assets/galacticraftMaps! : " + folder.toString());
        }
        catch (Exception e) {
            System.err.println(folder.toString());
            e.printStackTrace();
        }
        return null;
    }

    static {
        overworldImageCompressed = null;
        MapUtil.setupColours();
    }
}

