/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import biomesoplenty.api.item.BOPItems;
import ic2.api.item.IC2Items;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IPaintable;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpaceGlass;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityPainter
extends TileEntity
implements IDisableableMachine,
IInventoryDefaults,
IPacketReceiver {
    private static final int RANGE_DEFAULT = 96;
    public static Map<Integer, Set<BlockVec3>> loadedTilesForDim = new HashMap<Integer, Set<BlockVec3>>();
    public int range = 96;
    public int[] glassColor = new int[]{-1, -1, -1};
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private NonNullList<ItemStack> containingItems = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    public int guiColor = 0xFFFFFF;

    public void takeColorFromItem(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        int color = -1;
        if (item == Items.field_151100_aR) {
            color = ItemDye.field_150922_c[itemStack.func_77952_i()];
        } else if (item instanceof ItemBlock) {
            Block b = ((ItemBlock)item).func_179223_d();
            IBlockState bs = b.func_176203_a(itemStack.func_77952_i());
            try {
                MapColor mc = b.func_180659_g(bs, null, null);
                color = mc.field_76291_p;
            }
            catch (Exception exception) {}
        } else {
            color = TileEntityPainter.tryOtherModDyes(itemStack);
        }
        if (color >= 0) {
            this.guiColor = color = ColorUtil.addColorsBasic(color, this.guiColor);
        }
    }

    private void applyColorToItem(ItemStack itemStack, int color, Side side, EntityPlayer player) {
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (!(item instanceof IPaintable) && item instanceof ItemBlock) {
            color = ColorUtil.lighten(color, 0.03f);
            Block b = ((ItemBlock)item).func_179223_d();
            int result = 0;
            if (b instanceof IPaintable) {
                result = ((IPaintable)b).setColor(color, player, side);
            }
            if (b instanceof BlockSpaceGlass) {
                int type = ((BlockSpaceGlass)b).type.ordinal();
                this.glassColor[type] = color;
                if (result > 0 && side == Side.CLIENT) {
                    BlockSpaceGlass.updateClientRender();
                }
            }
        }
    }

    private void setGlassColors(int color1, int color2, int color3) {
        boolean changes = false;
        if (this.glassColor[0] != color1) {
            changes = true;
            this.glassColor[0] = color1;
        }
        if (this.glassColor[1] != color2) {
            changes = true;
            this.glassColor[1] = color2;
        }
        if (this.glassColor[2] != color3) {
            changes = true;
            this.glassColor[2] = color3;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("guic")) {
            this.glassColor[0] = nbt.func_74762_e("G1");
            this.glassColor[1] = nbt.func_74762_e("G2");
            this.glassColor[2] = nbt.func_74762_e("G3");
            this.range = nbt.func_74762_e("rge");
            this.guiColor = nbt.func_74762_e("guic");
        }
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.containingItems);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("G1", this.glassColor[0]);
        nbt.func_74768_a("G2", this.glassColor[1]);
        nbt.func_74768_a("G3", this.glassColor[2]);
        nbt.func_74768_a("guic", this.guiColor);
        nbt.func_74768_a("rge", this.range);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.containingItems);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private static Set<BlockVec3> getLoadedTiles(World world) {
        int dimID = GCCoreUtil.getDimensionID(world);
        Set<BlockVec3> loaded = loadedTilesForDim.get(dimID);
        if (loaded == null) {
            loaded = new HashSet<BlockVec3>();
            loadedTilesForDim.put(dimID, loaded);
        }
        return loaded;
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        } else {
            TileEntityPainter.getLoadedTiles(this.field_145850_b).add(new BlockVec3(this.field_174879_c));
        }
    }

    public void onChunkUnload() {
        TileEntityPainter.getLoadedTiles(this.field_145850_b).remove(new BlockVec3(this.field_174879_c));
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntityPainter.getLoadedTiles(this.field_145850_b).remove(new BlockVec3(this.field_174879_c));
        }
        super.func_145843_s();
    }

    public static void onServerTick(World world) {
        Set<BlockVec3> loaded = TileEntityPainter.getLoadedTiles(world);
        int dimID = GCCoreUtil.getDimensionID(world);
        List allPlayers = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        for (EntityPlayerMP player : allPlayers) {
            TileEntity te;
            if (player.field_71093_bK != dimID) continue;
            BlockVec3 playerPos = new BlockVec3((Entity)player);
            BlockVec3 nearest = null;
            int shortestDistance = 9216;
            for (BlockVec3 bv : loaded) {
                int distance = bv.distanceSquared(playerPos);
                if (distance >= shortestDistance) continue;
                shortestDistance = distance;
                nearest = bv;
            }
            if (nearest == null || !((te = nearest.getTileEntity((IBlockAccess)world)) instanceof TileEntityPainter)) continue;
            ((TileEntityPainter)te).dominantToPlayer(player);
        }
    }

    private void dominantToPlayer(EntityPlayerMP player) {
        GCPlayerStats.get((Entity)player).setGlassColors(this.glassColor[0], this.glassColor[1], this.glassColor[2]);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("tile.machine3.9.name");
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        for (EntityPlayer entityPlayer : this.playersUsing) {
            this.buttonPressed(index, entityPlayer, Side.SERVER);
        }
    }

    public void buttonPressed(int index, EntityPlayer player, Side side) {
        switch (index) {
            case 0: {
                this.applyColorToItem(this.func_70301_a(1), this.guiColor, side, player);
                break;
            }
            case 1: {
                this.takeColorFromItem(this.func_70301_a(0));
                break;
            }
            case 2: {
                this.guiColor = 0xFFFFFF;
            }
        }
    }

    @Override
    public boolean getDisabled(int index) {
        return false;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ItemStack func_70301_a(int par1) {
        return (ItemStack)this.containingItems.get(par1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.containingItems, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.containingItems, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.containingItems) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        sendData.add(this.guiColor);
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.field_145850_b.field_72995_K) {
            try {
                this.guiColor = buffer.readInt();
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
        }
    }

    private static int tryOtherModDyes(ItemStack itemStack) {
        ItemStack ic2paintbrush;
        Item item = itemStack.func_77973_b();
        if (CompatibilityManager.isIc2Loaded() && (ic2paintbrush = IC2Items.getItem((String)"painter")) != null && item == ic2paintbrush.func_77973_b()) {
            return ItemDye.field_150922_c[itemStack.func_77952_i()];
        }
        if (CompatibilityManager.isBOPLoaded()) {
            if (item == BOPItems.black_dye) {
                return ItemDye.field_150922_c[EnumDyeColor.BLACK.func_176767_b()];
            }
            if (item == BOPItems.blue_dye) {
                return ItemDye.field_150922_c[EnumDyeColor.BLUE.func_176767_b()];
            }
            if (item == BOPItems.brown_dye) {
                return ItemDye.field_150922_c[EnumDyeColor.BROWN.func_176767_b()];
            }
            if (item == BOPItems.green_dye) {
                return ItemDye.field_150922_c[EnumDyeColor.GREEN.func_176767_b()];
            }
            if (item == BOPItems.white_dye) {
                return ItemDye.field_150922_c[EnumDyeColor.WHITE.func_176767_b()];
            }
        }
        return -1;
    }
}

