/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockBasicMoon;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerClient
implements IPlayerClient {
    private boolean saveSneak;
    private double downMot2;
    public static boolean startup;

    @Override
    public void move(EntityPlayerSP player, MoverType type, double x, double y, double z) {
        this.updateFeet(player, x, z);
    }

    @Override
    public boolean wakeUpPlayer(EntityPlayerSP player, boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        return this.wakeUpPlayer(player, immediately, updateWorldFlag, setSpawn, false);
    }

    @Override
    public void onUpdate(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        stats.setTick(stats.getTick() + 1L);
        if (stats.isUsingParachute() && !player.field_71075_bZ.field_75100_b && !player.func_70072_I()) {
            player.field_70181_x = -0.5;
            player.field_70159_w *= 0.5;
            player.field_70179_y *= 0.5;
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock(EntityPlayerSP player, boolean vanillaInside) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        if (vanillaInside && stats.isInFreefall()) {
            stats.setInFreefall(false);
            return false;
        }
        return !(player.func_184187_bx() instanceof EntityLanderBase) && vanillaInside;
    }

    @Override
    public void onLivingUpdatePre(EntityPlayerSP player) {
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            if (!startup) {
                stats.setInFreefallLast(stats.isInFreefall());
                stats.setInFreefall(stats.getFreefallHandler().testFreefall((EntityPlayer)player));
                startup = true;
            }
            if (player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
                stats.setInFreefallLast(stats.isInFreefall());
                stats.setInFreefall(stats.getFreefallHandler().testFreefall((EntityPlayer)player));
                this.downMot2 = stats.getDownMotionLast();
                stats.setDownMotionLast(player.field_70181_x);
                stats.getFreefallHandler().preVanillaMotion(player);
            }
        }
    }

    public void cancelLimbSwing(EntityPlayerSP player) {
        player.field_184619_aG -= player.field_70721_aZ;
        player.field_70721_aZ = player.field_184618_aE;
        float adjust = Math.min(Math.abs(player.field_184619_aG), Math.abs(player.field_70721_aZ) / 3.0f);
        if (player.field_184619_aG < 0.0f) {
            player.field_184619_aG += adjust;
        } else if (player.field_184619_aG > 0.0f) {
            player.field_184619_aG -= adjust;
        }
        player.field_70721_aZ = (float)((double)player.field_70721_aZ * 0.9);
    }

    @Override
    public void onLivingUpdatePost(EntityPlayerSP player) {
        boolean ridingThirdPersonEntity;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        boolean bl = ridingThirdPersonEntity = player.func_184187_bx() instanceof ICameraZoomEntity && ((ICameraZoomEntity)player.func_184187_bx()).defaultThirdPerson();
        if (player.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            stats.getFreefallHandler().postVanillaMotion(player);
            if (stats.isInFreefall() || ridingThirdPersonEntity) {
                this.cancelLimbSwing(player);
            } else if (stats.isInFreefallLast() && this.downMot2 < -0.008) {
                stats.setLandingTicks(5 - (int)(Math.min(this.downMot2, stats.getDownMotionLast()) * 40.0));
                if (stats.getLandingTicks() > stats.getMaxLandingticks()) {
                    if (stats.getLandingTicks() > stats.getMaxLandingticks() + 4) {
                        stats.getFreefallHandler().pjumpticks = stats.getLandingTicks() - stats.getMaxLandingticks() - 5;
                    }
                    stats.setLandingTicks(stats.getMaxLandingticks());
                }
                float dYmax = 0.3f * (float)stats.getLandingTicks() / (float)stats.getMaxLandingticks();
                float factor = 1.0f;
                for (int i = 0; i <= stats.getLandingTicks(); ++i) {
                    stats.getLandingYOffset()[i] = dYmax * MathHelper.func_76126_a((float)((float)i * 3.1415925f / (float)stats.getLandingTicks())) * factor;
                    factor *= 0.97f;
                }
            }
            if (stats.getLandingTicks() > 0) {
                stats.setLandingTicks(stats.getLandingTicks() - 1);
                player.field_184619_aG *= 0.8f;
                player.field_70721_aZ = 0.0f;
            }
        } else {
            stats.setInFreefall(false);
            if (ridingThirdPersonEntity) {
                this.cancelLimbSwing(player);
            }
        }
        if (ridingThirdPersonEntity && !stats.isLastRidingCameraZoomEntity() && !ConfigManagerCore.disableVehicleCameraChanges) {
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = 1;
        }
        if (player.func_184187_bx() instanceof ICameraZoomEntity) {
            if (!ConfigManagerCore.disableVehicleCameraChanges) {
                stats.setLastZoomed(true);
                TickHandlerClient.zoom(((ICameraZoomEntity)player.func_184187_bx()).getCameraZoom());
            }
        } else if (stats.isLastZoomed() && !ConfigManagerCore.disableVehicleCameraChanges) {
            stats.setLastZoomed(false);
            TickHandlerClient.zoom(4.0f);
        }
        stats.setLastRidingCameraZoomEntity(ridingThirdPersonEntity);
        if (stats.isUsingParachute()) {
            player.field_70143_R = 0.0f;
        }
        PlayerGearData gearData = GalacticraftCore.proxy.getGearData((EntityPlayer)player);
        stats.setUsingParachute(false);
        if (gearData != null) {
            stats.setUsingParachute(gearData.getParachute() != null);
            if (!GalacticraftCore.isHeightConflictingModInstalled) {
                player.field_70131_O = gearData.getMask() != -1 ? 1.9375f : 1.8f;
                AxisAlignedBB bounds = player.func_174813_aQ();
                player.func_174826_a(new AxisAlignedBB(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, bounds.field_72336_d, bounds.field_72338_b + (double)player.field_70131_O, bounds.field_72334_f));
            }
        }
        if (stats.isUsingParachute() && player.field_70122_E) {
            stats.setUsingParachute(false);
            stats.setLastUsingParachute(false);
            FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = stats.getThirdPersonView();
        }
        if (!stats.isLastUsingParachute() && stats.isUsingParachute()) {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(GCSounds.parachute, SoundCategory.PLAYERS, 0.95f + player.func_70681_au().nextFloat() * 0.1f, 1.0f, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v));
        }
        stats.setLastUsingParachute(stats.isUsingParachute());
        stats.setLastOnGround(player.field_70122_E);
    }

    @Override
    public float getBedOrientationInDegrees(EntityPlayerSP player, float vanillaDegrees) {
        if (player.field_71081_bT != null) {
            if (player.field_70170_p.func_175625_s(player.field_71081_bT) instanceof TileEntityAdvanced) {
                IBlockState state = player.field_70170_p.func_180495_p(player.field_71081_bT);
                switch (state.func_177230_c().func_176201_c(state) - 4) {
                    case 0: {
                        return 90.0f;
                    }
                    case 1: {
                        return 270.0f;
                    }
                    case 2: {
                        return 180.0f;
                    }
                    case 3: {
                        return 0.0f;
                    }
                }
            } else {
                return vanillaDegrees;
            }
        }
        return vanillaDegrees;
    }

    private void updateFeet(EntityPlayerSP player, double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        BlockPos pos1;
        IBlockState state;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && player.field_70170_p != null && player.field_70170_p.field_73011_w instanceof WorldProviderMoon && player.func_184187_bx() == null && !player.field_71075_bZ.field_75100_b && (state = player.field_70170_p.func_180495_p(pos1 = new BlockPos(iPosX = MathHelper.func_76128_c((double)player.field_70165_t), iPosY = MathHelper.func_76128_c((double)(player.field_70163_u - 0.05)), iPosZ = MathHelper.func_76128_c((double)player.field_70161_v)))).func_177230_c() == GCBlocks.blockMoon && state.func_177229_b((IProperty)BlockBasicMoon.BASIC_TYPE_MOON) == BlockBasicMoon.EnumBlockBasicMoon.MOON_TURF) {
            if (stats.getDistanceSinceLastStep() > 0.35) {
                Vector3 pos = new Vector3((Entity)player);
                pos.y = (float)MathHelper.func_76128_c((double)player.field_70163_u) + player.func_70681_au().nextFloat() / 100.0f;
                switch (stats.getLastStep()) {
                    case 0: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z + 90.0f)) * 0.25));
                        break;
                    }
                    case 1: {
                        pos.translate(new Vector3(Math.sin(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25, 0.0, Math.cos(Math.toRadians(-player.field_70177_z - 90.0f)) * 0.25));
                    }
                }
                pos = WorldUtil.getFootprintPosition(player.field_70170_p, player.field_70177_z - 180.0f, pos, new BlockVec3((Entity)player));
                long chunkKey = ChunkPos.func_77272_a((int)(pos.intX() >> 4), (int)(pos.intZ() >> 4));
                FootprintRenderer.addFootprint(chunkKey, player.field_70170_p.field_73011_w.getDimension(), pos, player.field_70177_z, player.func_70005_c_());
                stats.setLastStep((stats.getLastStep() + 1) % 2);
                stats.setDistanceSinceLastStep(0.0);
            } else {
                stats.setDistanceSinceLastStep(stats.getDistanceSinceLastStep() + motionSqrd);
            }
        }
    }

    public boolean wakeUpPlayer(EntityPlayerSP player, boolean immediately, boolean updateWorldFlag, boolean setSpawn, boolean bypass) {
        BlockPos c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)player, c, immediately, updateWorldFlag, setSpawn, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EntityPlayer.SleepResult.OK) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBuild(int i, EntityPlayerSP player) {
        int repeatCount;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        int flag = stats.getBuildFlags();
        if (flag == -1) {
            flag = 0;
        }
        if ((repeatCount = flag >> 9) <= 3) {
            ++repeatCount;
        }
        if ((flag & 1 << i) > 0) {
            return;
        }
        stats.setBuildFlags(((flag |= 1 << i) & 0x1FF) + (repeatCount << 9));
        GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_BUILDFLAGS_UPDATE, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{stats.getBuildFlags()}));
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help1") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + Constants.PREFIX + "com/wiki/1" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + Constants.PREFIX + "com/wiki/1" + "\"}}]")));
                player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.message.help1a") + (Object)((Object)EnumColor.AQUA) + " /gchelp"));
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help2") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + Constants.PREFIX + "com/wiki/2" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + Constants.PREFIX + "com/wiki/2" + "\"}}]")));
                break;
            }
            case 7: {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.help3") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + Constants.PREFIX + "com/wiki/oil" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + Constants.PREFIX + "com/wiki/oil" + "\"}}]")));
                break;
            }
            case 8: {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"" + GCCoreUtil.translate("gui.message.prelaunch") + ": \",\"color\":\"white\"}," + "{\"text\":\" " + (Object)((Object)EnumColor.BRIGHT_GREEN) + "wiki." + Constants.PREFIX + "com/wiki/pre" + "\"," + "\"color\":\"green\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":" + "{\"text\":\"" + GCCoreUtil.translate("gui.message.clicklink") + "\",\"color\":\"yellow\"}}," + "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + "http://wiki." + Constants.PREFIX + "com/wiki/pre" + "\"}}]")));
            }
        }
    }
}

