/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.tile;

import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;

public class TileEntityFluidTankRenderer
extends TileEntitySpecialRenderer<TileEntityFluidTank> {
    public void render(TileEntityFluidTank tank, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        FluidTankInfo[] info = tank.getTankInfo(EnumFacing.DOWN);
        if (info.length != 1) {
            return;
        }
        FluidStack tankFluid = info[0].fluid;
        if (tankFluid == null || tankFluid.getFluid() == null || !tankFluid.getFluid().isGaseous() && tankFluid.amount == 0) {
            return;
        }
        TileEntityFluidTank tankAbove = tank.getNextTank(tank.func_174877_v());
        TileEntityFluidTank tankBelow = tank.getPreviousTank(tank.func_174877_v());
        this.func_147499_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(tankFluid.getFluid().getStill().toString());
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.5f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        float level = 1.0f;
        float levelInv = 0.0f;
        float opacity = 1.0f;
        boolean compositeGaseous = tankFluid.getFluid().isGaseous();
        if (compositeGaseous) {
            opacity = Math.min((float)tankFluid.amount / (float)info[0].capacity * 0.8f + 0.2f, 1.0f);
        } else {
            level = (float)tank.fluidTank.getFluidAmount() / 16400.0f;
            levelInv = 0.988f - level;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        if (levelInv < 1.0f) {
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(-0.4, (double)levelInv, -0.399).func_187315_a(uMin, vMin).func_181675_d();
            worldRenderer.func_181662_b(-0.4, 1.0, -0.399).func_187315_a(uMin, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(0.4, 1.0, -0.399).func_187315_a(uMax, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(0.4, (double)levelInv, -0.399).func_187315_a(uMax, vMin).func_181675_d();
            tess.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(0.4, (double)levelInv, 0.399).func_187315_a(uMax, vMin).func_181675_d();
            worldRenderer.func_181662_b(0.4, 1.0, 0.399).func_187315_a(uMax, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(-0.4, 1.0, 0.399).func_187315_a(uMin, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(-0.4, (double)levelInv, 0.399).func_187315_a(uMin, vMin).func_181675_d();
            tess.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(-0.399, 1.0, -0.4).func_187315_a(uMin, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(-0.399, (double)levelInv, -0.4).func_187315_a(uMin, vMin).func_181675_d();
            worldRenderer.func_181662_b(-0.399, (double)levelInv, 0.4).func_187315_a(uMax, vMin).func_181675_d();
            worldRenderer.func_181662_b(-0.399, 1.0, 0.4).func_187315_a(uMax, vMin + (vMax - vMin) * (double)level).func_181675_d();
            tess.func_78381_a();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldRenderer.func_181662_b(0.399, 1.0, 0.4).func_187315_a(uMax, vMin + (vMax - vMin) * (double)level).func_181675_d();
            worldRenderer.func_181662_b(0.399, (double)levelInv, 0.4).func_187315_a(uMax, vMin).func_181675_d();
            worldRenderer.func_181662_b(0.399, (double)levelInv, -0.4).func_187315_a(uMin, vMin).func_181675_d();
            worldRenderer.func_181662_b(0.399, 1.0, -0.4).func_187315_a(uMin, vMin + (vMax - vMin) * (double)level).func_181675_d();
            tess.func_78381_a();
            if (tankAbove == null || tankAbove.fluidTank.getFluidAmount() == 0 && !compositeGaseous) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b(0.4, 0.01 + (double)levelInv, 0.4).func_187315_a(uMax, vMax).func_181675_d();
                worldRenderer.func_181662_b(-0.4, 0.01 + (double)levelInv, 0.4).func_187315_a(uMax, vMin).func_181675_d();
                worldRenderer.func_181662_b(-0.4, 0.01 + (double)levelInv, -0.4).func_187315_a(uMin, vMin).func_181675_d();
                worldRenderer.func_181662_b(0.4, 0.01 + (double)levelInv, -0.4).func_187315_a(uMin, vMax).func_181675_d();
                tess.func_78381_a();
            }
            if (tankBelow == null || tankBelow.fluidTank.getFluidAmount() == 0 && !compositeGaseous) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b(0.4, 0.99, 0.4).func_187315_a(uMax, vMax).func_181675_d();
                worldRenderer.func_181662_b(0.4, 0.99, -0.4).func_187315_a(uMin, vMax).func_181675_d();
                worldRenderer.func_181662_b(-0.4, 0.99, -0.4).func_187315_a(uMin, vMin).func_181675_d();
                worldRenderer.func_181662_b(-0.4, 0.99, 0.4).func_187315_a(uMax, vMin).func_181675_d();
                tess.func_78381_a();
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

