/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.entities;

import java.lang.reflect.Field;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.client.model.ModelBipedGC;
import micdoodle8.mods.galacticraft.core.client.model.ModelPlayerGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerFrequencyModule;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerHeldItemGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerOxygenGear;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerOxygenMask;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerOxygenParachute;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerOxygenTanks;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerShield;
import micdoodle8.mods.galacticraft.core.client.render.entities.layer.LayerThermalPadding;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL11;

public class RenderPlayerGC
extends RenderPlayer {
    public static ResourceLocation thermalPaddingTexture0;
    public static ResourceLocation thermalPaddingTexture1;
    public static ResourceLocation thermalPaddingTexture1_T2;
    public static ResourceLocation heatShieldTexture;
    public static boolean flagThermalOverride;
    private static Boolean isSmartRenderLoaded;

    public RenderPlayerGC() {
        this(false);
    }

    public RenderPlayerGC(boolean smallArms) {
        super(FMLClientHandler.instance().getClient().func_175598_ae(), smallArms);
        this.field_77045_g = new ModelPlayerGC(0.0f, smallArms);
        this.addGCLayers();
    }

    private void addGCLayers() {
        int itemLayerIndex = -1;
        int armorLayerIndex = -1;
        for (int i = 0; i < this.field_177097_h.size(); ++i) {
            LayerRenderer layer = (LayerRenderer)this.field_177097_h.get(i);
            if (layer instanceof LayerHeldItem) {
                itemLayerIndex = i;
            }
            if (!(layer instanceof LayerBipedArmor)) continue;
            armorLayerIndex = i;
        }
        if (itemLayerIndex >= 0 && !ConfigManagerCore.disableVehicleCameraChanges) {
            this.field_177097_h.set(itemLayerIndex, new LayerHeldItemGC((RenderLivingBase<?>)this));
        }
        if (armorLayerIndex >= 0) {
            LayerBipedArmor playerArmor = new LayerBipedArmor((RenderLivingBase)this){

                protected void func_177177_a() {
                    this.field_177189_c = new ModelBipedGC(0.5f);
                    this.field_177186_d = new ModelBipedGC(1.0f);
                }
            };
            this.field_177097_h.set(armorLayerIndex, playerArmor);
        }
        this.func_177094_a(new LayerOxygenTanks(this));
        this.func_177094_a(new LayerOxygenGear(this));
        this.func_177094_a(new LayerOxygenMask(this));
        this.func_177094_a(new LayerOxygenParachute(this));
        this.func_177094_a(new LayerFrequencyModule(this));
        if (GalacticraftCore.isPlanetsLoaded) {
            this.func_177094_a((LayerRenderer)new LayerThermalPadding(this));
            thermalPaddingTexture0 = new ResourceLocation("galacticraftplanets", "textures/misc/thermal_padding_0.png");
            thermalPaddingTexture1 = new ResourceLocation("galacticraftplanets", "textures/misc/thermal_padding_1.png");
            thermalPaddingTexture1_T2 = new ResourceLocation("galacticraftplanets", "textures/misc/thermal_padding_t2_1.png");
            heatShieldTexture = new ResourceLocation("galacticraftplanets", "textures/misc/shield.png");
            this.func_177094_a(new LayerShield(this));
        }
    }

    public RenderPlayerGC(RenderPlayer old, boolean smallArms) {
        super(FMLClientHandler.instance().getClient().func_175598_ae(), smallArms);
        this.field_77045_g = new ModelPlayerGC(0.0f, smallArms);
        try {
            Field f = old.getClass().getSuperclass().getDeclaredField(GCCoreUtil.isDeobfuscated() ? "layerRenderers" : "field_177097_h");
            f.setAccessible(true);
            List layers = (List)f.get(old);
            if (layers.size() > 0) {
                this.field_177097_h.clear();
                for (LayerRenderer oldLayer : layers) {
                    this.func_177094_a(oldLayer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addGCLayers();
    }

    protected void func_77041_b(AbstractClientPlayer entitylivingbaseIn, float partialTickTime) {
        super.func_77041_b(entitylivingbaseIn, partialTickTime);
        if (entitylivingbaseIn.func_70089_S() && entitylivingbaseIn.func_70608_bn()) {
            RotatePlayerEvent event = new RotatePlayerEvent(entitylivingbaseIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.vanillaOverride) {
                super.func_77041_b(entitylivingbaseIn, partialTickTime);
            } else if (event.shouldRotate == null || event.shouldRotate.booleanValue()) {
                entitylivingbaseIn.field_70759_as = 0.0f;
                entitylivingbaseIn.field_70758_at = 0.0f;
                GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
            }
        }
    }

    protected void func_77043_a(AbstractClientPlayer abstractClientPlayer, float par2, float par3, float par4) {
        if (abstractClientPlayer.func_70089_S() && abstractClientPlayer.func_70608_bn()) {
            RotatePlayerEvent event = new RotatePlayerEvent(abstractClientPlayer);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.vanillaOverride) {
                super.func_77043_a(abstractClientPlayer, par2, par3, par4);
            } else if (event.shouldRotate == null) {
                GL11.glRotatef((float)abstractClientPlayer.func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (event.shouldRotate.booleanValue()) {
                IBlockState bed;
                float rotation = 0.0f;
                if (abstractClientPlayer.field_71081_bT != null && (bed = abstractClientPlayer.field_70170_p.func_180495_p(abstractClientPlayer.field_71081_bT)).func_177230_c().isBed(bed, (IBlockAccess)abstractClientPlayer.field_70170_p, abstractClientPlayer.field_71081_bT, (Entity)abstractClientPlayer)) {
                    TileEntity tile;
                    if (bed.func_177230_c() == GCBlocks.fakeBlock && bed.func_177229_b((IProperty)BlockMulti.MULTI_TYPE) == BlockMulti.EnumBlockMultiType.CRYO_CHAMBER && (tile = event.getEntityPlayer().field_70170_p.func_175625_s(abstractClientPlayer.field_71081_bT)) instanceof TileEntityMulti) {
                        bed = event.getEntityPlayer().field_70170_p.func_180495_p(((TileEntityMulti)tile).mainBlockPosition);
                    }
                    if (bed.func_177230_c() == MarsBlocks.machine && bed.func_177229_b((IProperty)BlockMachineMars.TYPE) == BlockMachineMars.EnumMachineType.CRYOGENIC_CHAMBER) {
                        switch ((EnumFacing)bed.func_177229_b((IProperty)BlockMachineMars.FACING)) {
                            case NORTH: {
                                rotation = 0.0f;
                                break;
                            }
                            case EAST: {
                                rotation = 270.0f;
                                break;
                            }
                            case SOUTH: {
                                rotation = 180.0f;
                                break;
                            }
                            case WEST: {
                                rotation = 90.0f;
                            }
                        }
                    }
                }
                GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            Entity rocket;
            float rotateOffset;
            AbstractClientPlayer player;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 && (player = abstractClientPlayer).func_184187_bx() instanceof ICameraZoomEntity && (rotateOffset = ((ICameraZoomEntity)(rocket = player.func_184187_bx())).getRotateOffset()) > -10.0f) {
                GL11.glTranslatef((float)0.0f, (float)(-rotateOffset), (float)0.0f);
                float anglePitch = rocket.field_70127_C;
                float angleYaw = rocket.field_70126_B;
                GL11.glRotatef((float)(-angleYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)anglePitch, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)rotateOffset, (float)0.0f);
            }
            super.func_77043_a(abstractClientPlayer, par2, par3, par4);
        }
    }

    static {
        flagThermalOverride = false;
        isSmartRenderLoaded = null;
    }

    public static class RotatePlayerEvent
    extends PlayerEvent {
        public Boolean shouldRotate = null;
        public boolean vanillaOverride = false;

        public RotatePlayerEvent(AbstractClientPlayer player) {
            super((EntityPlayer)player);
        }
    }
}

