/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.jei.ingotcompressor;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class IngotCompressorRecipeCategory
implements IRecipeCategory {
    private static final ResourceLocation compressorTex = new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/ingot_compressor.png");
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final IDrawableAnimated progressBar;

    public IngotCompressorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(compressorTex, 18, 17, 137, 78);
        this.localizedName = GCCoreUtil.translate("tile.machine.3.name");
        IDrawableStatic progressBarDrawable = guiHelper.createDrawable(compressorTex, 176, 13, 52, 17);
        this.progressBar = guiHelper.createAnimatedDrawable(progressBarDrawable, 70, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "galacticraft.ingotcompressor";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progressBar.draw(minecraft, 59, 19);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemstacks = recipeLayout.getItemStacks();
        for (int j = 0; j < 9; ++j) {
            itemstacks.init(j, true, j % 3 * 18, j / 3 * 18);
        }
        itemstacks.init(9, false, 119, 20);
        itemstacks.set(ingredients);
    }

    public String getModName() {
        return "Galacticraft Core";
    }
}

