/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import java.util.Iterator;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTier1TreasureChest
extends BlockContainer
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockTier1TreasureChest(String assetName) {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(100000.0f);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForSurroundingChests(worldIn, pos, state);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos1 = pos.func_177972_a(enumfacing);
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) continue;
            this.checkForSurroundingChests(worldIn, blockpos1, iblockstate1);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        boolean flag3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = this == worldIn.func_180495_p(blockpos1).func_177230_c();
        boolean flag1 = this == worldIn.func_180495_p(blockpos2).func_177230_c();
        boolean flag2 = this == worldIn.func_180495_p(blockpos3).func_177230_c();
        boolean bl = flag3 = this == worldIn.func_180495_p(blockpos4).func_177230_c();
        if (!(flag || flag1 || flag2 || flag3)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.X && (flag || flag1)) {
            if (flag) {
                worldIn.func_180501_a(blockpos1, state, 3);
            } else {
                worldIn.func_180501_a(blockpos2, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flag2 || flag3)) {
            if (flag2) {
                worldIn.func_180501_a(blockpos3, state, 3);
            } else {
                worldIn.func_180501_a(blockpos4, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityTreasureChest) {
            ((TileEntityTreasureChest)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    public IBlockState checkForSurroundingChests(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            return state;
        }
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate4 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block block = iblockstate1.func_177230_c();
        Block block1 = iblockstate2.func_177230_c();
        Block block2 = iblockstate3.func_177230_c();
        Block block3 = iblockstate4.func_177230_c();
        if (block != this && block1 != this) {
            boolean flag = block.func_149730_j(iblockstate1);
            boolean flag1 = block1.func_149730_j(iblockstate2);
            if (block2 == this || block3 == this) {
                BlockPos blockpos2 = block2 == this ? pos.func_177976_e() : pos.func_177974_f();
                IBlockState iblockstate7 = worldIn.func_180495_p(blockpos2.func_177978_c());
                IBlockState iblockstate8 = worldIn.func_180495_p(blockpos2.func_177968_d());
                enumfacing = EnumFacing.SOUTH;
                EnumFacing enumfacing2 = block2 == this ? (EnumFacing)iblockstate3.func_177229_b((IProperty)FACING) : (EnumFacing)iblockstate4.func_177229_b((IProperty)FACING);
                if (enumfacing2 == EnumFacing.NORTH) {
                    enumfacing = EnumFacing.NORTH;
                }
                Block block6 = iblockstate7.func_177230_c();
                Block block7 = iblockstate8.func_177230_c();
                if ((flag || block6.func_149730_j(iblockstate7)) && !flag1 && !block7.func_149730_j(iblockstate8)) {
                    enumfacing = EnumFacing.SOUTH;
                }
                if ((flag1 || block7.func_149730_j(iblockstate8)) && !flag && !block6.func_149730_j(iblockstate7)) {
                    enumfacing = EnumFacing.NORTH;
                }
            }
        } else {
            BlockPos blockpos1 = block == this ? pos.func_177978_c() : pos.func_177968_d();
            IBlockState iblockstate5 = worldIn.func_180495_p(blockpos1.func_177976_e());
            IBlockState iblockstate6 = worldIn.func_180495_p(blockpos1.func_177974_f());
            enumfacing = EnumFacing.EAST;
            EnumFacing enumfacing1 = block == this ? (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING) : (EnumFacing)iblockstate2.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST) {
                enumfacing = EnumFacing.WEST;
            }
            Block block4 = iblockstate5.func_177230_c();
            Block block5 = iblockstate6.func_177230_c();
            if ((block2.func_149730_j(iblockstate3) || block4.func_149730_j(iblockstate5)) && !block3.func_149730_j(iblockstate4) && !block5.func_149730_j(iblockstate6)) {
                enumfacing = EnumFacing.EAST;
            }
            if ((block3.func_149730_j(iblockstate4) || block5.func_149730_j(iblockstate6)) && !block2.func_149730_j(iblockstate3) && !block4.func_149730_j(iblockstate5)) {
                enumfacing = EnumFacing.WEST;
            }
        }
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        worldIn.func_180501_a(pos, state, 3);
        return state;
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing1));
            if (iblockstate1.func_177230_c() == this) {
                return state;
            }
            if (!iblockstate1.func_177230_c().func_149730_j(iblockstate1)) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState state1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing2));
        if (state1.func_177230_c().func_149730_j(state1)) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if ((state1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing2))).func_177230_c().func_149730_j(state1)) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if ((state1 = worldIn.func_180495_p(pos.func_177972_a(enumfacing2))).func_177230_c().func_149730_j(state1)) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)enumfacing2);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        int i = 0;
        BlockPos blockpos1 = pos.func_177976_e();
        BlockPos blockpos2 = pos.func_177974_f();
        BlockPos blockpos3 = pos.func_177978_c();
        BlockPos blockpos4 = pos.func_177968_d();
        if (worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos1)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos2).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos2)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos3).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos3)) {
                return false;
            }
            ++i;
        }
        if (worldIn.func_180495_p(blockpos4).func_177230_c() == this) {
            if (this.isDoubleChest(worldIn, blockpos4)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    private boolean isDoubleChest(World worldIn, BlockPos pos) {
        EnumFacing enumfacing;
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return false;
        }
        Iterator iterator = EnumFacing.Plane.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (worldIn.func_180495_p(pos.func_177972_a(enumfacing = (EnumFacing)iterator.next())).func_177230_c() != this);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityTreasureChest) {
            tileentity.func_145836_u();
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        playerIn.func_71007_a((IInventory)tile);
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTreasureChest();
    }

    public int isProvidingWeakPower(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        if (!this.func_149744_f(state)) {
            return 0;
        }
        int i = 0;
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityTreasureChest) {
            i = ((TileEntityTreasureChest)tileentity).numPlayersUsing;
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)15);
    }

    public int isProvidingStrongPower(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return side == EnumFacing.UP ? this.isProvidingWeakPower(worldIn, pos, state, side) : 0;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        Entity entity;
        EntityOcelot entityocelot;
        Iterator iterator = worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(entityocelot = (EntityOcelot)(entity = (Entity)iterator.next())).func_70906_o());
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TREASURE;
    }
}

