/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.item.IPaintable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpaceGlass
extends Block
implements IPartialSealableBlock,
IShiftDescription,
ISortableBlock,
IPaintable {
    public static final PropertyEnum MODEL = PropertyEnum.func_177709_a((String)"modeltype", GlassModel.class);
    public static final PropertyEnum ROTATION = PropertyEnum.func_177709_a((String)"rot", GlassRotation.class);
    public final GlassType type;
    private final GlassFrame frame;
    private int color = 0xFFFFFF;
    private final Block baseBlock;
    private boolean isClient = GalacticraftCore.proxy.getClass().getName().equals("micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore");
    private static Class clazz = Blocks.field_150355_j.getClass().getSuperclass();

    public BlockSpaceGlass(String assetName, GlassType newType, GlassFrame newFrame, Block base) {
        super(Material.field_151592_s);
        this.type = newType;
        this.frame = newFrame;
        this.baseBlock = base == null ? this : base;
        this.color = this.frame.getDefaultColor();
        this.func_149663_c(assetName);
        this.func_149672_a(SoundType.field_185853_f);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_PANE)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL, ROTATION});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.frame == GlassFrame.PLAIN) {
            for (int i = 0; i < GlassFrame.values().length; ++i) {
                list.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (meta >= GlassFrame.values().length) {
            meta = 0;
        }
        switch (GlassFrame.values()[meta]) {
            case TIN_DECO: {
                switch (this.type) {
                    case STRONG: {
                        return GCBlocks.spaceGlassTinStrong.func_176223_P();
                    }
                    case VANILLA: {
                        return GCBlocks.spaceGlassTinVanilla.func_176223_P();
                    }
                }
                return GCBlocks.spaceGlassTinClear.func_176223_P();
            }
        }
        return this.func_176223_P();
    }

    public int func_180651_a(IBlockState state) {
        return this.frame.ordinal();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.baseBlock);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(this.func_180660_a(state, null, fortune), 1, this.frame.ordinal()));
        return ret;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return direction.ordinal() > 1;
    }

    public Material func_149688_o(IBlockState state) {
        if (this.isClient && JavaUtil.instance.isCalledBySpecific(clazz)) {
            return Material.field_151586_h;
        }
        return this.field_149764_J;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing dir) {
        IBlockState thisBlock = world.func_180495_p(pos);
        if ((dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH) && this.isConnectedEW(thisBlock, world, pos)) {
            return false;
        }
        if ((dir == EnumFacing.WEST || dir == EnumFacing.EAST) && this.isConnectedNS(thisBlock, world, pos)) {
            return false;
        }
        IBlockState otherBlock = world.func_180495_p(pos.func_177972_a(dir.func_176734_d()));
        return this.buildSolidSide(otherBlock, thisBlock);
    }

    protected boolean isConnectedEW(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
        return this.canPaneConnectToBlock(west, state) || this.canPaneConnectToBlock(east, state);
    }

    protected boolean isConnectedEWRecursive(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing dir) {
        boolean connectN = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177978_c()), state);
        boolean connectS = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177968_d()), state);
        boolean connectW = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177976_e()), state);
        boolean connectE = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177974_f()), state);
        if (connectN || connectS || connectW || connectE) {
            return (connectW || connectE) && !connectN && !connectS;
        }
        BlockPos next = pos.func_177967_a(dir, 1);
        IBlockState nextState = worldIn.func_180495_p(next);
        if (nextState.func_177230_c() == this) {
            return this.isConnectedEWRecursive(nextState, worldIn, next, dir);
        }
        return dir == EnumFacing.DOWN && this.isPreferenceEW(state, worldIn, pos);
    }

    protected boolean isConnectedNS(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
        return this.canPaneConnectToBlock(north, state) || this.canPaneConnectToBlock(south, state);
    }

    protected boolean isConnectedNSRecursive(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing dir) {
        boolean connectN = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177978_c()), state);
        boolean connectS = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177968_d()), state);
        boolean connectW = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177976_e()), state);
        boolean connectE = this.canPaneConnectToBlock(worldIn.func_180495_p(pos.func_177974_f()), state);
        if (connectN || connectS || connectW || connectE) {
            return (connectN || connectS) && !connectW && !connectE;
        }
        BlockPos next = pos.func_177967_a(dir, 1);
        IBlockState nextState = worldIn.func_180495_p(next);
        if (nextState.func_177230_c() == this) {
            return this.isConnectedNSRecursive(nextState, worldIn, next, dir);
        }
        return dir == EnumFacing.DOWN && !this.isPreferenceEW(state, worldIn, pos);
    }

    protected boolean isPreferenceEW(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
        int solidsEW = (west.func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177976_e()), worldIn, pos.func_177976_e(), EnumFacing.EAST) ? 1 : 0) + (east.func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177974_f()), worldIn, pos.func_177974_f(), EnumFacing.WEST) ? 1 : 0);
        int solidsNS = (north.func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177978_c()), worldIn, pos.func_177978_c(), EnumFacing.SOUTH) ? 1 : 0) + (south.func_177230_c().isSideSolid(worldIn.func_180495_p(pos.func_177968_d()), worldIn, pos.func_177968_d(), EnumFacing.NORTH) ? 1 : 0);
        return solidsEW > solidsNS;
    }

    protected boolean canPaneConnectToBlock(IBlockState off, IBlockState blockState) {
        return off.func_177230_c() == this;
    }

    protected boolean buildSolidSide(IBlockState off, IBlockState blockState) {
        return off.func_177230_c() != this;
    }

    protected boolean buildSolidSideUD(BlockPos pos, EnumFacing testUD, IBlockAccess worldIn, IBlockState blockState) {
        BlockPos offPos = pos.func_177967_a(testUD, 1);
        IBlockState off = worldIn.func_180495_p(offPos);
        if (off.func_177230_c() != this) {
            return true;
        }
        int connThis = (this.isConnectedEW(blockState, worldIn, pos) ? 2 : 0) + (this.isConnectedNS(blockState, worldIn, pos) ? 1 : 0);
        int connOther = (this.isConnectedEW(off, worldIn, offPos) ? 2 : 0) + (this.isConnectedNS(off, worldIn, offPos) ? 1 : 0);
        if (connThis == 0 && connOther == 0) {
            return false;
        }
        int trueThis = this.identifyHorizConnections(worldIn, pos, blockState);
        int trueOther = this.identifyHorizConnections(worldIn, offPos, off);
        if (connThis == 0 && ((trueOther & 3) == 0 && trueThis != 3 || (trueOther & 0xC) == 0 && trueThis == 3)) {
            return false;
        }
        if (connOther == 0 && ((trueThis & 3) == 0 && trueOther != 3 || (trueThis & 0xC) == 0 && trueOther == 3)) {
            return false;
        }
        if (connThis != connOther) {
            return true;
        }
        if (trueThis < 3 || trueThis == 4 || trueThis == 8) {
            return false;
        }
        if (trueOther < 3 || trueOther == 4 || trueOther == 8) {
            return false;
        }
        if ((trueThis & 7) != (trueOther & 7)) {
            return true;
        }
        if ((trueThis & 0xB) != (trueOther & 0xB)) {
            return true;
        }
        if ((trueThis & 0xD) != (trueOther & 0xD)) {
            return true;
        }
        return (trueThis & 0xE) != (trueOther & 0xE);
    }

    private int identifyHorizConnections(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
        boolean connectN = this.canPaneConnectToBlock(north, state);
        boolean connectS = this.canPaneConnectToBlock(south, state);
        boolean connectW = this.canPaneConnectToBlock(west, state);
        boolean connectE = this.canPaneConnectToBlock(east, state);
        int connections = (connectN ? 1 : 0) + (connectS ? 1 : 0) + (connectW ? 1 : 0) + (connectE ? 1 : 0);
        if (!(connectN || connectS || connectW || connectE)) {
            IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
            IBlockState below = worldIn.func_180495_p(pos.func_177977_b());
            if (below.func_177230_c() == this && this.isConnectedEWRecursive(below, worldIn, pos.func_177977_b(), EnumFacing.DOWN)) {
                return 3;
            }
            if (above.func_177230_c() == this && this.isConnectedEWRecursive(above, worldIn, pos.func_177984_a(), EnumFacing.UP)) {
                return 3;
            }
            if (below.func_177230_c() == this && this.isConnectedNSRecursive(below, worldIn, pos.func_177977_b(), EnumFacing.DOWN)) {
                return 12;
            }
            if (above.func_177230_c() == this && this.isConnectedNSRecursive(above, worldIn, pos.func_177984_a(), EnumFacing.UP)) {
                return 12;
            }
            if (this.isPreferenceEW(state, worldIn, pos)) {
                return 3;
            }
        }
        return (connectN ? 8 : 0) + (connectS ? 4 : 0) + (connectW ? 2 : 0) + (connectE ? 1 : 0);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState above = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState below = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
        boolean connectN = this.canPaneConnectToBlock(north, state);
        boolean connectS = this.canPaneConnectToBlock(south, state);
        boolean connectW = this.canPaneConnectToBlock(west, state);
        boolean connectE = this.canPaneConnectToBlock(east, state);
        boolean plateD = this.buildSolidSideUD(pos, EnumFacing.DOWN, worldIn, state);
        boolean plateU = this.buildSolidSideUD(pos, EnumFacing.UP, worldIn, state);
        boolean plateN = this.buildSolidSide(north, state);
        boolean plateS = this.buildSolidSide(south, state);
        boolean plateW = this.buildSolidSide(west, state);
        boolean plateE = this.buildSolidSide(east, state);
        int connections = (connectN ? 1 : 0) + (connectS ? 1 : 0) + (connectW ? 1 : 0) + (connectE ? 1 : 0);
        GlassRotation rot = GlassRotation.N;
        int cornerPiece = 0;
        if (connections == 4) {
            return this.getModel(state, 4, rot, plateD, false, false, plateU, 0);
        }
        if (connections == 3) {
            if (!connectE) {
                rot = GlassRotation.S;
            } else if (!connectN) {
                rot = GlassRotation.E;
            } else if (!connectS) {
                rot = GlassRotation.W;
            }
            return this.getModel(state, 3, rot, plateD, false, false, plateU, 0);
        }
        if (connections == 0) {
            if (below.func_177230_c() == this && this.isConnectedEWRecursive(below, worldIn, pos.func_177977_b(), EnumFacing.DOWN)) {
                rot = GlassRotation.E;
            } else if (above.func_177230_c() == this && this.isConnectedEWRecursive(above, worldIn, pos.func_177984_a(), EnumFacing.UP)) {
                rot = GlassRotation.E;
            }
            if (!(below.func_177230_c() == this && this.isConnectedNSRecursive(below, worldIn, pos.func_177977_b(), EnumFacing.DOWN) || above.func_177230_c() == this && this.isConnectedNSRecursive(above, worldIn, pos.func_177984_a(), EnumFacing.UP) || !this.isPreferenceEW(state, worldIn, pos))) {
                rot = GlassRotation.E;
            }
            return this.getModel(state, 1, rot, plateD, plateS, plateN, plateU, 0);
        }
        if (connectW && connectE || connections == 1 && (connectW || connectE)) {
            rot = GlassRotation.E;
            if (connectW && !plateU && this.buildSolidSideUD(pos.func_177976_e(), EnumFacing.UP, worldIn, west)) {
                ++cornerPiece;
            }
            if (connectW && !plateD && this.buildSolidSideUD(pos.func_177976_e(), EnumFacing.DOWN, worldIn, west)) {
                cornerPiece += 5;
            }
            if (connectE && !plateU && this.buildSolidSideUD(pos.func_177974_f(), EnumFacing.UP, worldIn, east)) {
                ++cornerPiece;
                if (connectW) {
                    rot = GlassRotation.W;
                }
            }
            if (connectE && !plateD && this.buildSolidSideUD(pos.func_177974_f(), EnumFacing.DOWN, worldIn, east)) {
                cornerPiece += 5;
                if (connectW) {
                    rot = GlassRotation.W;
                }
            }
            return this.getModel(state, 1, rot, plateD, plateW, plateE, plateU, cornerPiece);
        }
        if (connectN && connectS || connections == 1) {
            if (connectN && !plateU && this.buildSolidSideUD(pos.func_177978_c(), EnumFacing.UP, worldIn, north)) {
                if (!connectS) {
                    cornerPiece |= 5;
                    if (!plateD) {
                        rot = GlassRotation.S;
                    }
                } else {
                    cornerPiece |= 1;
                    rot = GlassRotation.S;
                }
            }
            if (connectN && !plateD && this.buildSolidSideUD(pos.func_177978_c(), EnumFacing.DOWN, worldIn, north)) {
                ++cornerPiece;
                if (connectS) {
                    rot = GlassRotation.S;
                }
            }
            if (connectS && !plateU && this.buildSolidSideUD(pos.func_177968_d(), EnumFacing.UP, worldIn, south)) {
                if (cornerPiece == 0 && !plateD) {
                    cornerPiece = 5;
                    rot = GlassRotation.S;
                } else if ((cornerPiece & 3) < 2) {
                    ++cornerPiece;
                }
            }
            if (connectS && !plateD && this.buildSolidSideUD(pos.func_177968_d(), EnumFacing.DOWN, worldIn, south)) {
                cornerPiece = (cornerPiece & 3) < 2 ? ++cornerPiece : (cornerPiece |= 5);
            }
            return this.getModel(state, 1, rot, plateD, plateS, plateN, plateU, cornerPiece);
        }
        if (connectW && connectS) {
            rot = GlassRotation.S;
        } else if (connectS && connectE) {
            rot = GlassRotation.E;
        } else if (connectN && connectW) {
            rot = GlassRotation.W;
        }
        return this.getModel(state, 2, rot, plateD, false, false, plateU, 0);
    }

    private IBlockState getModel(IBlockState state, int model, GlassRotation rot, boolean plateD, boolean plateL, boolean plateR, boolean plateU, int cornerPiece) {
        int x = 0;
        int y = rot.ordinal();
        if (y % 2 == 1) {
            y ^= 2;
        }
        int solids = (plateD ? 1 : 0) + (plateU ? 1 : 0) + (plateR ? 1 : 0) + (plateL ? 1 : 0);
        switch (model) {
            case 1: {
                if (solids == 4) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_S4)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (solids == 3) {
                    if (!plateD) {
                        x = y % 2 == 1 ? 3 : 1;
                    } else if (!plateR) {
                        x = 2;
                        y ^= 2;
                    } else if (!plateU) {
                        x = y % 2 == 1 ? 1 : 3;
                    }
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_S3)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, x)));
                }
                if (plateD && plateU) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_S2A)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateL && plateR) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_S2A)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 1)));
                }
                if (plateD && (plateR || plateL)) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)(cornerPiece > 0 ? GlassModel.STANDARD_S2B : GlassModel.STANDARD_S2))).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(plateL ? y ^ 2 : y, 0)));
                }
                if (plateU && (plateR || plateL)) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)(cornerPiece > 0 ? GlassModel.STANDARD_S2B : GlassModel.STANDARD_S2))).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(plateL ? y ^ 2 : y, 2)));
                }
                if (plateU || plateD) {
                    return state.func_177226_a((IProperty)MODEL, this.getCornerModel(cornerPiece)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, plateU || cornerPiece > 4 ? 2 : 0)));
                }
                if (plateR || plateL) {
                    return state.func_177226_a((IProperty)MODEL, this.getCornerModel(cornerPiece)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(plateL ? y ^ 2 : y, 1 + (cornerPiece > 4 ? 2 : 0))));
                }
                return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.STANDARD_PANE)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
            }
            case 2: {
                if (plateU && plateD) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CORNER_S2)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateD) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CORNER_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateU) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CORNER_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get((y + 3) % 4, 2)));
                }
                return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CORNER)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
            }
            case 3: {
                if (plateD && plateU) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.T_JUNCTION_S2)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateD) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.T_JUNCTION_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateU) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.T_JUNCTION_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y ^ 2, 2)));
                }
                return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.T_JUNCTION)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, x)));
            }
            case 4: {
                if (plateD && plateU) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CROSSROADS_S2)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (plateD) {
                    return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CROSSROADS_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, 0)));
                }
                if (!plateU) break;
                return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CROSSROADS_S)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y ^ 2, 2)));
            }
        }
        return state.func_177226_a((IProperty)MODEL, (Comparable)((Object)GlassModel.CROSSROADS)).func_177226_a((IProperty)ROTATION, (Comparable)((Object)GlassRotation.get(y, x)));
    }

    private Comparable getCornerModel(int cornerPiece) {
        if ((cornerPiece & 2) == 2) {
            return GlassModel.STANDARD_S1BB;
        }
        return cornerPiece > 0 ? GlassModel.STANDARD_S1B : GlassModel.STANDARD_S1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public int setColor(int newColor, EntityPlayer p, Side side) {
        if (newColor >= 0 && this.color != newColor) {
            this.color = newColor;
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateGlassColors(int color1, int color2, int color3) {
        int changes = 0;
        changes += GCBlocks.spaceGlassVanilla.setColor(color1, null, Side.CLIENT);
        changes += GCBlocks.spaceGlassClear.setColor(color2, null, Side.CLIENT);
        if ((changes += GCBlocks.spaceGlassStrong.setColor(color3, null, Side.CLIENT)) > 0) {
            BlockSpaceGlass.updateClientRender();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateClientRender() {
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }

    @Override
    public String getShiftDescription(int meta) {
        switch (this.type) {
            case CLEAR: {
                return GCCoreUtil.translate("tile.space_glass.clear.description");
            }
            case VANILLA: {
                return GCCoreUtil.translate("tile.space_glass.description");
            }
        }
        return GCCoreUtil.translate("tile.space_glass.strong.description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public static enum GlassType implements IStringSerializable
    {
        VANILLA("vanilla"),
        CLEAR("clear"),
        STRONG("strong");

        private final String name;

        private GlassType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum GlassFrame implements IStringSerializable
    {
        PLAIN("plain", 0xFAFAF7),
        TIN_DECO("tin_deco", 0xFFFFFF);

        private final String name;
        private final int defaultColor;

        private GlassFrame(String name, int color) {
            this.name = name;
            this.defaultColor = color;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }
    }

    public static enum GlassRotation implements IStringSerializable
    {
        N("0"),
        E("y"),
        S("yy"),
        W("yyy"),
        UN("u"),
        UE("uyyy"),
        US("uyy"),
        UW("uy"),
        UUN("uuyy"),
        UUE("uuyyy"),
        UUS("uu"),
        UUW("uuy"),
        DN("d"),
        DE("dy"),
        DS("dyy"),
        DW("dyyy");

        private final String name;

        private GlassRotation(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        private static GlassRotation get(int i) {
            return GlassRotation.values()[i];
        }

        private static GlassRotation get(int y, int x) {
            int i = y + x * 4;
            return GlassRotation.values()[i];
        }
    }

    public static enum GlassModel implements IStringSerializable
    {
        STANDARD_PANE("standard"),
        CORNER("corner"),
        T_JUNCTION("joint"),
        CROSSROADS("joinx"),
        STANDARD_S1("standards1"),
        STANDARD_S1B("standards1b"),
        STANDARD_S1BB("standards1bb"),
        STANDARD_S2("standards2"),
        STANDARD_S2A("standards2a"),
        STANDARD_S2B("standards2b"),
        STANDARD_S3("standards3"),
        STANDARD_S4("standards4"),
        CORNER_S("corner_s"),
        CORNER_S2("corner_s2"),
        T_JUNCTION_S("joint_s"),
        T_JUNCTION_S2("joint_s2"),
        CROSSROADS_S("joinx_s"),
        CROSSROADS_S2("joinx_s2");

        private final String name;

        private GlassModel(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

