/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAirLockWall
extends BlockBreakable
implements IPartialSealableBlock,
ISortableBlock {
    public static final PropertyEnum CONNECTION_TYPE = PropertyEnum.func_177709_a((String)"connection", EnumAirLockSealConnection.class);
    protected static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB AABB_FLAT = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 0.75, 1.0);

    public BlockAirLockWall(String assetName) {
        super(Material.field_151573_f, false);
        this.func_149675_a(true);
        this.func_149711_c(1000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (this.getConnection(source, pos)) {
            case X: {
                return AABB_X;
            }
            case Z: {
                return AABB_Z;
            }
        }
        return AABB_FLAT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @Override
    public boolean isSealed(World worldIn, BlockPos pos, EnumFacing direction) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTION_TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)CONNECTION_TYPE, (Comparable)((Object)this.getConnection(worldIn, pos)));
    }

    private EnumAirLockSealConnection getConnection(IBlockAccess worldIn, BlockPos pos) {
        EnumAirLockSealConnection connection;
        Block frameID = GCBlocks.airLockFrame;
        Block sealID = GCBlocks.airLockSeal;
        Block idXMin = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c();
        Block idXMax = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c();
        if (idXMin != frameID && idXMax != frameID && idXMin != sealID && idXMax != sealID) {
            connection = EnumAirLockSealConnection.X;
        } else {
            int adjacentCount = 0;
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                Block blockID = worldIn.func_180495_p(pos.func_177972_a(dir)).func_177230_c();
                if (blockID != GCBlocks.airLockFrame && blockID != GCBlocks.airLockSeal) continue;
                ++adjacentCount;
            }
            connection = adjacentCount == 4 ? EnumAirLockSealConnection.FLAT : EnumAirLockSealConnection.Z;
        }
        return connection;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public static enum EnumAirLockSealConnection implements IStringSerializable
    {
        X("x"),
        Z("z"),
        FLAT("flat");

        private final String name;

        private EnumAirLockSealConnection(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

