/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockAdvanced
extends Block {
    public BlockAdvanced(Material material) {
        super(material);
        this.func_149711_c(0.6f);
        this.func_149752_b(2.5f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (this.useWrench(worldIn, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (playerIn.func_70093_af() && this.onSneakMachineActivated(worldIn, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        return this.onMachineActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    protected boolean useWrench(World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isUsableWrench(playerIn, heldItem, pos)) {
            this.damageWrench(playerIn, heldItem, pos);
            if (playerIn.func_70093_af() && this.onSneakUseWrench(worldIn, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
                playerIn.func_184609_a(hand);
                return true;
            }
            if (this.onUseWrench(worldIn, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
                playerIn.func_184609_a(hand);
                return true;
            }
        }
        return false;
    }

    public boolean isUsableWrench(EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos) {
        if (entityPlayer != null && itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (item == GCItems.wrench) {
                return true;
            }
            Class<?> wrenchClass = item.getClass();
            try {
                Method methodCanWrench = wrenchClass.getMethod("canWrench", EntityPlayer.class, BlockPos.class);
                return (Boolean)methodCanWrench.invoke((Object)item, entityPlayer, pos);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (CompatibilityManager.isIc2Loaded() && (wrenchClass == CompatibilityManager.classIC2wrench || wrenchClass == CompatibilityManager.classIC2wrenchElectric)) {
                return itemStack.func_77952_i() < itemStack.func_77958_k();
            }
        }
        return false;
    }

    public boolean damageWrench(EntityPlayer entityPlayer, ItemStack itemStack, BlockPos pos) {
        if (this.isUsableWrench(entityPlayer, itemStack, pos)) {
            Class<?> wrenchClass = itemStack.func_77973_b().getClass();
            try {
                Method methodWrenchUsed = wrenchClass.getMethod("wrenchUsed", EntityPlayer.class, BlockPos.class);
                methodWrenchUsed.invoke((Object)itemStack.func_77973_b(), entityPlayer, pos);
                return true;
            }
            catch (Exception methodWrenchUsed) {
                try {
                    if (wrenchClass == CompatibilityManager.classIC2wrench || wrenchClass == CompatibilityManager.classIC2wrenchElectric) {
                        Method methodWrenchDamage = wrenchClass.getMethod("damage", ItemStack.class, Integer.TYPE, EntityPlayer.class);
                        methodWrenchDamage.invoke((Object)itemStack.func_77973_b(), itemStack, 1, entityPlayer);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean onMachineActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakMachineActivated(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.onUseWrench(world, pos, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void rotate6Ways(World world, BlockPos pos) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        int metaDir = ((metadata & 7) + 1) % 6;
        if (metaDir == 3) {
            metaDir = 5;
        } else if (metaDir == 0) {
            metaDir = 3;
        } else if (metaDir == 5) {
            metaDir = 0;
        }
        world.func_180501_a(pos, this.func_176203_a(metaDir), 3);
    }
}

