/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CircuitFabricatorRecipes {
    private static HashMap<NonNullList<ItemStack>, ItemStack> recipes = new HashMap();
    public static ArrayList<ArrayList<ItemStack>> slotValidItems = new ArrayList(5);

    public static void addRecipe(ItemStack output, NonNullList<ItemStack> inputList) {
        int i;
        if (inputList.size() != 5) {
            throw new RuntimeException("Invalid circuit fabricator recipe!");
        }
        recipes.put(inputList, output);
        if (slotValidItems.size() == 0) {
            for (i = 0; i < 5; ++i) {
                ArrayList entry = new ArrayList();
                slotValidItems.add(entry);
            }
        }
        for (i = 0; i < 5; ++i) {
            ItemStack inputStack = (ItemStack)inputList.get(i);
            if (inputStack.func_190926_b()) continue;
            ArrayList<ItemStack> validItems = slotValidItems.get(i);
            boolean found = false;
            for (ItemStack validItem : validItems) {
                if (!inputStack.func_77969_a(validItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            validItems.add(inputStack.func_77946_l());
        }
    }

    public static ItemStack getOutputForInput(List<ItemStack> inputList) {
        if (inputList.size() != 5) {
            return ItemStack.field_190927_a;
        }
        for (Map.Entry<NonNullList<ItemStack>, ItemStack> recipe : recipes.entrySet()) {
            boolean found = true;
            for (int i = 0; i < 5; ++i) {
                ItemStack recipeStack = (ItemStack)recipe.getKey().get(i);
                ItemStack inputStack = inputList.get(i);
                if (recipeStack.func_190926_b() || inputStack.func_190926_b()) {
                    if (recipeStack.func_190926_b() && inputStack.func_190926_b()) continue;
                    found = false;
                    break;
                }
                if (recipeStack.func_77973_b() == inputStack.func_77973_b() && recipeStack.func_77952_i() == inputStack.func_77952_i()) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return recipe.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public static void removeRecipe(ItemStack match) {
        recipes.entrySet().removeIf(recipe -> ItemStack.func_77989_b((ItemStack)match, (ItemStack)((ItemStack)recipe.getValue())));
    }

    public static ImmutableMap<List<ItemStack>, ItemStack> getRecipes() {
        return ImmutableMap.copyOf(recipes);
    }
}

