/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IMobSpawnBiome;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.builder.EqualsBuilder;

public abstract class CelestialBody
implements Comparable<CelestialBody> {
    protected final String bodyName;
    protected String unlocalizedName;
    protected float relativeSize = 1.0f;
    protected ScalableDistance relativeDistanceFromCenter = new ScalableDistance(1.0f, 1.0f);
    protected float relativeOrbitTime = 1.0f;
    protected float phaseShift = 0.0f;
    protected int dimensionID = -1;
    protected Class<? extends WorldProvider> providerClass;
    protected String dimensionSuffix;
    protected boolean autoRegisterDimension = false;
    protected boolean isReachable = false;
    protected boolean forceStaticLoad = true;
    protected int tierRequired = 0;
    public AtmosphereInfo atmosphere = new AtmosphereInfo(false, false, false, 0.0f, 0.0f, 1.0f);
    protected LinkedList<Biome> biomeInfo;
    protected LinkedList<Biome.SpawnListEntry> mobInfo;
    protected ResourceLocation celestialBodyIcon;
    protected float ringColorR = 1.0f;
    protected float ringColorG = 1.0f;
    protected float ringColorB = 1.0f;
    protected ArrayList<String> checklistKeys = new ArrayList();

    public CelestialBody(String bodyName) {
        this.bodyName = bodyName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = bodyName;
    }

    public abstract int getID();

    public abstract String getUnlocalizedNamePrefix();

    public String getName() {
        return this.bodyName;
    }

    public String getUnlocalizedName() {
        return this.getUnlocalizedNamePrefix() + "." + this.unlocalizedName;
    }

    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        s = s == null ? "" : I18n.func_74838_a((String)s);
        int comment = s.indexOf(35);
        return comment > 0 ? s.substring(0, comment).trim() : s;
    }

    public float getRelativeSize() {
        return this.relativeSize;
    }

    public ScalableDistance getRelativeDistanceFromCenter() {
        return this.relativeDistanceFromCenter;
    }

    public float getPhaseShift() {
        return this.phaseShift;
    }

    public float getRelativeOrbitTime() {
        return this.relativeOrbitTime;
    }

    public int getTierRequirement() {
        return this.tierRequired;
    }

    public CelestialBody setTierRequired(int tierRequired) {
        this.tierRequired = tierRequired;
        return this;
    }

    public CelestialBody setRelativeSize(float relativeSize) {
        this.relativeSize = relativeSize;
        return this;
    }

    public CelestialBody setRelativeDistanceFromCenter(ScalableDistance relativeDistanceFromCenter) {
        this.relativeDistanceFromCenter = relativeDistanceFromCenter;
        return this;
    }

    public CelestialBody setPhaseShift(float phaseShift) {
        this.phaseShift = phaseShift;
        return this;
    }

    public CelestialBody setRelativeOrbitTime(float relativeOrbitTime) {
        this.relativeOrbitTime = relativeOrbitTime;
        return this;
    }

    public CelestialBody setAtmosphere(AtmosphereInfo atmos) {
        this.atmosphere = atmos;
        return this;
    }

    public CelestialBody setDimensionInfo(int dimID, Class<? extends WorldProvider> providerClass) {
        return this.setDimensionInfo(dimID, providerClass, true);
    }

    public CelestialBody setDimensionInfo(int providerId, Class<? extends WorldProvider> providerClass, boolean autoRegister) {
        this.dimensionID = providerId;
        this.providerClass = providerClass;
        this.autoRegisterDimension = autoRegister;
        this.isReachable = true;
        return this;
    }

    public boolean shouldAutoRegister() {
        return this.autoRegisterDimension;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public Class<? extends WorldProvider> getWorldProvider() {
        return this.providerClass;
    }

    public boolean getReachable() {
        return this.isReachable;
    }

    public CelestialBody atmosphereComponent(EnumAtmosphericGas gas) {
        this.atmosphere.composition.add(gas);
        return this;
    }

    public CelestialBody setRingColorRGB(float ringColorR, float ringColorG, float ringColorB) {
        this.ringColorR = ringColorR;
        this.ringColorG = ringColorG;
        this.ringColorB = ringColorB;
        return this;
    }

    public float getRingColorR() {
        return this.ringColorR;
    }

    public float getRingColorG() {
        return this.ringColorG;
    }

    public float getRingColorB() {
        return this.ringColorB;
    }

    public ResourceLocation getBodyIcon() {
        return this.celestialBodyIcon;
    }

    public CelestialBody setBodyIcon(ResourceLocation planetIcon) {
        this.celestialBodyIcon = planetIcon;
        return this;
    }

    public boolean getForceStaticLoad() {
        return this.forceStaticLoad;
    }

    public CelestialBody setForceStaticLoad(boolean force) {
        this.forceStaticLoad = force;
        return this;
    }

    public void addChecklistKeys(String ... keys) {
        this.checklistKeys.addAll(Arrays.asList(keys));
    }

    public List<String> getChecklistKeys() {
        return this.checklistKeys;
    }

    public int hashCode() {
        return this.getUnlocalizedName().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CelestialBody) {
            return new EqualsBuilder().append((Object)this.getUnlocalizedName(), (Object)((CelestialBody)other).getUnlocalizedName()).isEquals();
        }
        return false;
    }

    @Override
    public int compareTo(CelestialBody other) {
        ScalableDistance thisDistance = this.getRelativeDistanceFromCenter();
        ScalableDistance otherDistance = other.getRelativeDistanceFromCenter();
        return otherDistance.unScaledDistance < thisDistance.unScaledDistance ? 1 : (otherDistance.unScaledDistance > thisDistance.unScaledDistance ? -1 : 0);
    }

    public void setUnreachable() {
        this.isReachable = false;
    }

    public String getDimensionSuffix() {
        return this.dimensionSuffix;
    }

    public void setDimensionSuffix(String dimensionSuffix) {
        this.dimensionSuffix = dimensionSuffix;
    }

    public void setBiomeInfo(Biome ... biome) {
        if (this.biomeInfo == null) {
            this.biomeInfo = new LinkedList();
        }
        this.biomeInfo.addAll(Arrays.asList(biome));
    }

    public void addMobInfo(Biome.SpawnListEntry entry) {
        if (this.mobInfo == null) {
            this.mobInfo = new LinkedList();
        }
        this.mobInfo.add(entry);
    }

    public void initialiseMobSpawns() {
        if (this.biomeInfo != null && this.mobInfo != null) {
            for (Biome biome : this.biomeInfo) {
                if (!(biome instanceof IMobSpawnBiome)) continue;
                ((IMobSpawnBiome)biome).initialiseMobLists(this.mobInfo);
            }
        }
    }

    public List<Block> getSurfaceBlocks() {
        if (this.providerClass != null && IGalacticraftWorldProvider.class.isAssignableFrom(this.providerClass)) {
            try {
                return ((IGalacticraftWorldProvider)this.providerClass.newInstance()).getSurfaceBlocks();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static class ScalableDistance {
        public final float unScaledDistance;
        public final float scaledDistance;

        public ScalableDistance(float unScaledDistance, float scaledDistance) {
            this.unScaledDistance = unScaledDistance;
            this.scaledDistance = scaledDistance;
        }
    }
}

